/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ResultMergeFrameLocalMemory
extends ResultMerge<FrameObject> {
    private static final long serialVersionUID = 549739254879310540L;

    public ResultMergeFrameLocalMemory(FrameObject out, FrameObject[] in, String outputFilename, boolean accum) {
        super((CacheableData)out, (CacheableData[])in, outputFilename, accum);
    }

    @Override
    public FrameObject executeSerialMerge() {
        FrameObject foNew = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ResultMerge (local, in-memory): Execute serial merge for output " + ((FrameObject)this._output).hashCode() + " (fname=" + ((FrameObject)this._output).getFileName() + ")"));
        }
        try {
            FrameBlock outFB = (FrameBlock)((FrameObject)this._output).acquireRead();
            FrameBlock outFBNew = new FrameBlock(outFB);
            FrameBlock compare = outFB;
            int rlen = compare.getNumRows();
            int clen = compare.getNumColumns();
            boolean flagMerged = false;
            for (FrameObject in : (FrameObject[])this._inputs) {
                if (in == null || in == this._output) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ResultMergeFrame (local, in-memory): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ")"));
                }
                FrameBlock inMB = (FrameBlock)in.acquireRead();
                for (int j = 0; j < clen; ++j) {
                    Types.ValueType vt = compare.getSchema()[j];
                    for (int i = 0; i < rlen; ++i) {
                        Object val2;
                        Object val1 = compare.get(i, j);
                        if (UtilFunctions.compareTo(vt, val1, val2 = inMB.get(i, j)) == 0) continue;
                        outFBNew.set(i, j, val2);
                    }
                }
                in.release();
                in.clearData();
                flagMerged = true;
            }
            foNew = flagMerged ? ResultMergeFrameLocalMemory.createNewFrameObject((FrameObject)this._output, outFBNew) : (FrameObject)this._output;
            ((FrameObject)this._output).release();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return foNew;
    }

    @Override
    public FrameObject executeParallelMerge(int par) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ResultMerge (local, in-memory): Execute parallel (par=" + par + ") merge for output " + ((FrameObject)this._output).hashCode() + " (fname=" + ((FrameObject)this._output).getFileName() + ")"));
        }
        return this.executeSerialMerge();
    }

    private static FrameObject createNewFrameObject(FrameObject foOld, FrameBlock dataNew) {
        FrameObject ret = new FrameObject(foOld);
        ret.acquireModify(dataNew);
        ret.release();
        return ret;
    }
}

