/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public abstract class CompressedSizeEstimator {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeEstimator.class.getName());
    protected final MatrixBlock _data;
    protected final int _numRows;
    protected final int _numCols;
    protected final CompressionSettings _cs;
    protected boolean _transposed;

    protected CompressedSizeEstimator(MatrixBlock data, CompressionSettings cs) {
        this._data = data;
        this._transposed = cs.transposed;
        this._numRows = this._transposed ? this._data.getNumColumns() : this._data.getNumRows();
        this._numCols = this._transposed ? this._data.getNumRows() : this._data.getNumColumns();
        this._cs = cs;
    }

    public int getNumRows() {
        return this._numRows;
    }

    public int getNumColumns() {
        return this._numCols;
    }

    public CompressedSizeInfo computeCompressedSizeInfos(int k) {
        List<CompressedSizeInfoColGroup> sizeInfos = Arrays.asList(this.estimateIndividualColumnGroupSizes(k));
        return new CompressedSizeInfo(sizeInfos);
    }

    public List<CompressedSizeInfoColGroup> computeCompressedSizeInfos(Collection<int[]> columnLists, int k) {
        if (k == 1) {
            return this.computeCompressedSizeInfos(columnLists);
        }
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<SizeEstimationTask> tasks = new ArrayList<SizeEstimationTask>();
            for (int[] g : columnLists) {
                tasks.add(new SizeEstimationTask(this, g));
            }
            List rtask = pool.invokeAll(tasks);
            ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
            for (Future lrtask : rtask) {
                ret.add((CompressedSizeInfoColGroup)lrtask.get());
            }
            pool.shutdown();
            return ret;
        }
        catch (InterruptedException | ExecutionException e) {
            return this.computeCompressedSizeInfos(columnLists);
        }
    }

    public List<CompressedSizeInfoColGroup> computeCompressedSizeInfos(Collection<int[]> columnLists) {
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
        for (int[] g : columnLists) {
            ret.add(this.estimateCompressedColGroupSize(g));
        }
        return ret;
    }

    private CompressedSizeInfoColGroup[] estimateIndividualColumnGroupSizes(int k) {
        return k > 1 ? this.CompressedSizeInfoColGroup(this._numCols, k) : this.CompressedSizeInfoColGroup(this._numCols);
    }

    public CompressedSizeInfoColGroup estimateCompressedColGroupSize() {
        int[] colIndexes = this.makeColIndexes();
        return this.estimateCompressedColGroupSize(colIndexes);
    }

    public CompressedSizeInfoColGroup estimateCompressedColGroupSize(int[] colIndexes) {
        return this.estimateCompressedColGroupSize(colIndexes, Integer.MAX_VALUE);
    }

    public abstract CompressedSizeInfoColGroup estimateCompressedColGroupSize(int[] var1, int var2);

    public CompressedSizeInfoColGroup estimateJoinCompressedSize(CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        int g2V;
        int[] joined = Util.join(g1.getColumns(), g2.getColumns());
        int g1V = g1.getNumVals();
        if (g1V * (g2V = g2.getNumVals()) < 0 || g1V * g2V > this.getNumRows()) {
            return null;
        }
        if (joined.length == 2 || g1.getMap() == null && g2V != 0 || g2.getMap() == null && g2V != 0) {
            return this.estimateCompressedColGroupSize(joined, (g1V + 1) * (g2V + 1));
        }
        return this.estimateJoinCompressedSize(joined, g1, g2);
    }

    protected abstract CompressedSizeInfoColGroup estimateJoinCompressedSize(int[] var1, CompressedSizeInfoColGroup var2, CompressedSizeInfoColGroup var3);

    public EstimationFactors estimateCompressedColGroupSize(ABitmap ubm, int[] colIndexes) {
        return CompressedSizeEstimator.estimateCompressedColGroupSize(ubm, colIndexes, this._numRows, this._cs);
    }

    public static EstimationFactors estimateCompressedColGroupSize(ABitmap ubm, int[] colIndexes, int nrRows, CompressionSettings cs) {
        return EstimationFactors.computeSizeEstimationFactors(ubm, cs.validCompressions.contains((Object)AColGroup.CompressionType.RLE), colIndexes);
    }

    private CompressedSizeInfoColGroup[] CompressedSizeInfoColGroup(int clen) {
        CompressedSizeInfoColGroup[] ret = new CompressedSizeInfoColGroup[clen];
        for (int col = 0; col < clen; ++col) {
            ret[col] = this.estimateCompressedColGroupSize(new int[]{col});
        }
        return ret;
    }

    private CompressedSizeInfoColGroup[] CompressedSizeInfoColGroup(int clen, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<SizeEstimationTask> tasks = new ArrayList<SizeEstimationTask>();
            for (int col = 0; col < clen; ++col) {
                tasks.add(new SizeEstimationTask(this, col));
            }
            List rtask = pool.invokeAll(tasks);
            ArrayList ret = new ArrayList();
            for (Future lrtask : rtask) {
                ret.add(lrtask.get());
            }
            pool.shutdown();
            return ret.toArray(new CompressedSizeInfoColGroup[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            return this.CompressedSizeInfoColGroup(clen);
        }
    }

    private int[] makeColIndexes() {
        int[] colIndexes = new int[this._numCols];
        for (int i = 0; i < this._numCols; ++i) {
            colIndexes[i] = i;
        }
        return colIndexes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" transposed: ");
        sb.append(this._transposed);
        sb.append(" cols: ");
        sb.append(this._numCols);
        sb.append(" rows: ");
        sb.append(this._numRows);
        return sb.toString();
    }

    private static class SizeEstimationTask
    implements Callable<CompressedSizeInfoColGroup> {
        private final CompressedSizeEstimator _estimator;
        private final int[] _cols;

        protected SizeEstimationTask(CompressedSizeEstimator estimator, int col) {
            this._estimator = estimator;
            this._cols = new int[]{col};
        }

        protected SizeEstimationTask(CompressedSizeEstimator estimator, int[] cols) {
            this._estimator = estimator;
            this._cols = cols;
        }

        @Override
        public CompressedSizeInfoColGroup call() {
            return this._estimator.estimateCompressedColGroupSize(this._cols);
        }
    }
}

