/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.encode.Encoder;
import org.apache.sysds.runtime.transform.encode.EncoderBin;
import org.apache.sysds.runtime.transform.encode.EncoderComposite;
import org.apache.sysds.runtime.transform.encode.EncoderDummycode;
import org.apache.sysds.runtime.transform.encode.EncoderFeatureHash;
import org.apache.sysds.runtime.transform.encode.EncoderMVImpute;
import org.apache.sysds.runtime.transform.encode.EncoderOmit;
import org.apache.sysds.runtime.transform.encode.EncoderPassThrough;
import org.apache.sysds.runtime.transform.encode.EncoderRecode;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.util.CollectionUtils;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONObject;

public class EncoderFactory {
    public static Encoder createEncoder(String spec, String[] colnames, int clen, FrameBlock meta) {
        return EncoderFactory.createEncoder(spec, colnames, UtilFunctions.nCopies(clen, Types.ValueType.STRING), meta);
    }

    public static Encoder createEncoder(String spec, String[] colnames, int clen, FrameBlock meta, int minCol, int maxCol) {
        return EncoderFactory.createEncoder(spec, colnames, UtilFunctions.nCopies(clen, Types.ValueType.STRING), meta, minCol, maxCol);
    }

    public static Encoder createEncoder(String spec, String[] colnames, Types.ValueType[] schema, int clen, FrameBlock meta) {
        Types.ValueType[] lschema = schema == null ? UtilFunctions.nCopies(clen, Types.ValueType.STRING) : schema;
        return EncoderFactory.createEncoder(spec, colnames, lschema, meta);
    }

    public static Encoder createEncoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta) {
        return EncoderFactory.createEncoder(spec, colnames, schema, meta, -1, -1);
    }

    public static Encoder createEncoder(String spec, String[] colnames, Types.ValueType[] schema, FrameBlock meta, int minCol, int maxCol) {
        EncoderComposite encoder = null;
        int clen = schema.length;
        try {
            JSONObject jSpec = new JSONObject(spec);
            ArrayList<Encoder> lencoders = new ArrayList<Encoder>();
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.RECODE.toString(), minCol, maxCol)));
            List<Integer> haIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.HASH.toString(), minCol, maxCol)));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.DUMMYCODE.toString(), minCol, maxCol)));
            List<Integer> binIDs = TfMetaUtils.parseBinningColIDs(jSpec, colnames, minCol, maxCol);
            rcIDs = CollectionUtils.except(CollectionUtils.unionDistinct(rcIDs, CollectionUtils.except(dcIDs, binIDs)), haIDs);
            List<Integer> ptIDs = CollectionUtils.except(CollectionUtils.except(UtilFunctions.getSeqList(1, clen, 1), CollectionUtils.unionDistinct(rcIDs, haIDs)), binIDs);
            List<Integer> oIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonIDList(jSpec, colnames, TfUtils.TfMethod.OMIT.toString(), minCol, maxCol)));
            List<Integer> mvIDs = Arrays.asList(ArrayUtils.toObject((int[])TfMetaUtils.parseJsonObjectIDList(jSpec, colnames, TfUtils.TfMethod.IMPUTE.toString(), minCol, maxCol)));
            if (!rcIDs.isEmpty()) {
                EncoderRecode ra = new EncoderRecode(jSpec, colnames, clen, minCol, maxCol);
                ra.setColList(ArrayUtils.toPrimitive((Integer[])rcIDs.toArray(new Integer[0])));
                lencoders.add(ra);
            }
            if (!haIDs.isEmpty()) {
                EncoderFeatureHash ha = new EncoderFeatureHash(jSpec, colnames, clen, minCol, maxCol);
                ha.setColList(ArrayUtils.toPrimitive((Integer[])haIDs.toArray(new Integer[0])));
                lencoders.add(ha);
            }
            if (!ptIDs.isEmpty()) {
                lencoders.add(new EncoderPassThrough(ArrayUtils.toPrimitive((Integer[])ptIDs.toArray(new Integer[0])), clen));
            }
            if (!binIDs.isEmpty()) {
                lencoders.add(new EncoderBin(jSpec, colnames, schema.length, minCol, maxCol));
            }
            if (!dcIDs.isEmpty()) {
                lencoders.add(new EncoderDummycode(jSpec, colnames, schema.length, minCol, maxCol));
            }
            if (!oIDs.isEmpty()) {
                lencoders.add(new EncoderOmit(jSpec, colnames, schema.length, minCol, maxCol));
            }
            if (!mvIDs.isEmpty()) {
                EncoderMVImpute ma = new EncoderMVImpute(jSpec, colnames, schema.length, minCol, maxCol);
                ma.initRecodeIDList(rcIDs);
                lencoders.add(ma);
            }
            encoder = new EncoderComposite(lencoders);
            if (meta != null) {
                Object[] colnames2 = meta.getColumnNames();
                if (!TfMetaUtils.isIDSpec(jSpec) && colnames != null && colnames2 != null && !ArrayUtils.isEquals((Object)colnames, (Object)colnames2)) {
                    HashMap<String, Integer> colPos = EncoderFactory.getColumnPositions((String[])colnames2);
                    FrameBlock meta2 = new FrameBlock(meta.getSchema(), (String[])colnames2);
                    meta2.setNumRows(meta.getNumRows());
                    for (int i = 0; i < colnames.length; ++i) {
                        if (!colPos.containsKey(colnames[i])) {
                            throw new DMLRuntimeException("Column name not found in meta data: " + colnames[i] + " (meta: " + Arrays.toString(colnames2) + ")");
                        }
                        int pos = colPos.get(colnames[i]);
                        meta2.setColumn(i, meta.getColumn(pos));
                        meta2.setColumnMetadata(i, meta.getColumnMetadata(pos));
                    }
                    meta = meta2;
                }
                ((Encoder)encoder).initMetaData(meta);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return encoder;
    }

    private static HashMap<String, Integer> getColumnPositions(String[] colnames) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (int i = 0; i < colnames.length; ++i) {
            ret.put(colnames[i], i);
        }
        return ret;
    }
}

