/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.CustomHashMap;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class DblArrayIntListHashMap
extends CustomHashMap {
    protected static final Log LOG = LogFactory.getLog((String)DblArrayIntListHashMap.class.getName());
    private DArrayIListEntry[] _data = null;

    public DblArrayIntListHashMap() {
        this._data = new DArrayIListEntry[8];
        this._size = 0;
    }

    public DblArrayIntListHashMap(int init_capacity) {
        this._data = new DArrayIListEntry[init_capacity];
        this._size = 0;
    }

    public IntArrayList get(DblArray key) {
        if (this._size == 0) {
            return null;
        }
        int hash = DblArrayIntListHashMap.hash(key);
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        DArrayIListEntry e = this._data[ix];
        while (e != null) {
            if (e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public void appendValue(DblArray key, IntArrayList value) {
        int hash = DblArrayIntListHashMap.hash(key);
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        DArrayIListEntry enew = new DArrayIListEntry(key, value);
        enew.next = this._data[ix];
        this._data[ix] = enew;
        if (enew.next != null && enew.next.key == key) {
            enew.next = enew.next.next;
            --this._size;
        }
        ++this._size;
        if ((float)this._size >= 0.75f * (float)this._data.length) {
            this.resize();
        }
    }

    public ArrayList<DArrayIListEntry> extractValues() {
        ArrayList<DArrayIListEntry> ret = new ArrayList<DArrayIListEntry>();
        for (DArrayIListEntry e : this._data) {
            if (e == null) continue;
            while (e.next != null) {
                ret.add(e);
                e = e.next;
            }
            ret.add(e);
        }
        Collections.sort(ret);
        LOG.info(ret);
        return ret;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            return;
        }
        DArrayIListEntry[] olddata = this._data;
        this._data = new DArrayIListEntry[this._data.length * 2];
        this._size = 0;
        for (DArrayIListEntry e : olddata) {
            if (e == null) continue;
            while (e.next != null) {
                this.appendValue(e.key, e.value);
                e = e.next;
            }
            this.appendValue(e.key, e.value);
        }
    }

    private static int hash(DblArray key) {
        int h = key.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public class DArrayIListEntry
    implements Comparator<DArrayIListEntry>,
    Comparable<DArrayIListEntry> {
        public DblArray key;
        public IntArrayList value;
        public DArrayIListEntry next;

        public DArrayIListEntry(DblArray ekey, IntArrayList evalue) {
            this.key = ekey;
            this.value = evalue;
            this.next = null;
        }

        @Override
        public int compare(DArrayIListEntry o1, DArrayIListEntry o2) {
            double[] o1d = o1.key.getData();
            double[] o2d = o2.key.getData();
            for (int i = 0; i < o1d.length && i < o2d.length; ++i) {
                if (o1d[i] > o2d[i]) {
                    return 1;
                }
                if (!(o1d[i] < o2d[i])) continue;
                return -1;
            }
            if (o1d.length > o2d.length) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compareTo(DArrayIListEntry o) {
            return this.compare(this, o);
        }
    }
}

