/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.sysml.api.DMLException;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.UtilFunctions;

public class BinaryBlockToRowBlockConverter
implements Converter<MatrixIndexes, MatrixBlock, MatrixIndexes, MatrixBlock> {
    private MatrixBlock _srcBlock = null;
    private int _srcRlen = -1;
    private int _srcBrlen = -1;
    private int _pos = -1;
    private long _startRowID = -1L;
    private long _colID = -1L;
    private MatrixIndexes _destIx = new MatrixIndexes();
    private MatrixBlock _destBlock = new MatrixBlock();
    private Pair<MatrixIndexes, MatrixBlock> _pair = new Pair<MatrixIndexes, MatrixBlock>(this._destIx, this._destBlock);

    private void reset() {
        this._srcBlock = null;
        this._pos = -1;
        this._startRowID = -1L;
        this._colID = -1L;
    }

    @Override
    public void convert(MatrixIndexes k1, MatrixBlock v1) {
        this.reset();
        this._startRowID = UtilFunctions.computeCellIndex(k1.getRowIndex(), this._srcBrlen, 0);
        this._colID = k1.getColumnIndex();
        this._destBlock.reset(1, v1.getNumColumns());
        this._srcRlen = v1.getNumRows();
        this._srcBlock = v1;
        this._pos = 0;
    }

    @Override
    public boolean hasNext() {
        return this._pos < this._srcRlen;
    }

    @Override
    public Pair<MatrixIndexes, MatrixBlock> next() {
        if (this._pos >= this._srcRlen) {
            return null;
        }
        this._destIx.setIndexes(this._startRowID + (long)this._pos, this._colID);
        try {
            this._srcBlock.slice(this._pos, this._pos, 0, this._srcBlock.getNumColumns() - 1, this._destBlock);
        }
        catch (DMLException ex) {
            throw new RuntimeException("Failed to slice matrix block into row blocks.", ex);
        }
        ++this._pos;
        return this._pair;
    }

    @Override
    public void setBlockSize(int nr, int nc) {
        this._srcBrlen = nr;
    }
}

