/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.FileFormatPropertiesMM;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.FastStringTokenizer;
import org.apache.sysml.runtime.util.MapReduceTool;

public class ReaderTextCell
extends MatrixReader {
    protected final boolean _allowRawRead;
    protected final boolean _isMMFile;
    protected FileFormatPropertiesMM _mmProps = null;

    public ReaderTextCell(InputInfo info) {
        this(info, true);
    }

    public ReaderTextCell(InputInfo info, boolean allowRaw) {
        this._allowRawRead = allowRaw;
        this._isMMFile = info == InputInfo.MatrixMarketInputInfo;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf(ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, job);
        ReaderTextCell.checkValidInputFile(fs, path);
        if (this._isMMFile) {
            this._mmProps = IOUtilFunctions.readAndParseMatrixMarketHeader(fname);
        }
        if (estnnz < 0L) {
            estnnz = MapReduceTool.estimateNnzBasedOnFileSize(path, rlen, clen, brlen, bclen, 3.0);
        }
        MatrixBlock ret = ReaderTextCell.createOutputMatrixBlock(rlen, clen, (int)rlen, (int)clen, estnnz, true, false);
        if (fs.isDirectory(path) || !this._allowRawRead) {
            this.readTextCellMatrixFromHDFS(path, job, ret, rlen, clen, brlen, bclen);
        } else {
            ReaderTextCell.readRawTextCellMatrixFromHDFS(path, job, fs, ret, rlen, clen, brlen, bclen, this._isMMFile);
        }
        ret.examSparsity();
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = ReaderTextCell.createOutputMatrixBlock(rlen, clen, brlen, bclen, estnnz, true, false);
        ReaderTextCell.readRawTextCellMatrixFromInputStream(is, ret, rlen, clen, brlen, bclen, this._isMMFile);
        ret.examSparsity();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTextCellMatrixFromHDFS(Path path, JobConf job, MatrixBlock dest, long rlen, long clen, int brlen, int bclen) throws IOException {
        boolean sparse = dest.isInSparseFormat();
        FileInputFormat.addInputPath(job, path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        LongWritable key = new LongWritable();
        Text value = new Text();
        IJV cell = new IJV();
        long nnz = 0L;
        try {
            FastStringTokenizer st = new FastStringTokenizer(' ');
            for (InputSplit split : splits) {
                RecordReader<LongWritable, Text> reader = informat.getRecordReader(split, job, Reporter.NULL);
                try {
                    if (sparse) {
                        while (reader.next(key, value)) {
                            cell = ReaderTextCell.parseCell(value.toString(), st, cell, this._mmProps);
                            ReaderTextCell.appendCell(cell, dest, this._mmProps);
                        }
                        dest.sortSparseRows();
                        continue;
                    }
                    DenseBlock a = dest.getDenseBlock();
                    while (reader.next(key, value)) {
                        cell = ReaderTextCell.parseCell(value.toString(), st, cell, this._mmProps);
                        nnz += (long)ReaderTextCell.appendCell(cell, a, this._mmProps);
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
            if (!dest.isInSparseFormat()) {
                dest.setNonZeros(nnz);
            }
        }
        catch (Exception ex) {
            if (cell.getI() < 0 || (long)(cell.getI() + 1) > rlen || cell.getJ() < 0 || (long)(cell.getJ() + 1) > clen) {
                throw new IOException("Matrix cell [" + (cell.getI() + 1) + "," + (cell.getJ() + 1) + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            throw new IOException("Unable to read matrix in text cell format.", ex);
        }
    }

    protected static IJV parseCell(String line, FastStringTokenizer st, IJV cell, FileFormatPropertiesMM mmProps) {
        st.reset(line.toString());
        int row = st.nextInt() - 1;
        int col = st.nextInt() - 1;
        double value = mmProps == null ? st.nextDouble() : (mmProps.isPatternField() ? 1.0 : (mmProps.isIntField() ? (double)st.nextLong() : st.nextDouble()));
        return cell.set(row, col, value);
    }

    protected static int appendCell(IJV cell, MatrixBlock dest, FileFormatPropertiesMM mmProps) {
        if (cell.getV() == 0.0) {
            return 0;
        }
        dest.appendValue(cell.getI(), cell.getJ(), cell.getV());
        if (mmProps != null && mmProps.isSymmetric() && !cell.onDiag()) {
            dest.appendValue(cell.getJ(), cell.getI(), cell.getV());
            return 2;
        }
        return 1;
    }

    protected static int appendCell(IJV cell, DenseBlock dest, FileFormatPropertiesMM mmProps) {
        if (cell.getV() == 0.0) {
            return 0;
        }
        dest.set(cell.getI(), cell.getJ(), cell.getV());
        if (mmProps != null && mmProps.isSymmetric() && !cell.onDiag()) {
            dest.set(cell.getJ(), cell.getI(), cell.getV());
            return 2;
        }
        return 1;
    }

    private static void readRawTextCellMatrixFromHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock dest, long rlen, long clen, int brlen, int bclen, boolean matrixMarket) throws IOException {
        FSDataInputStream inputStream = fs.open(path);
        ReaderTextCell.readRawTextCellMatrixFromInputStream(inputStream, dest, rlen, clen, brlen, bclen, matrixMarket);
    }

    private static void readRawTextCellMatrixFromInputStream(InputStream is, MatrixBlock dest, long rlen, long clen, int brlen, int bclen, boolean matrixMarket) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        FileFormatPropertiesMM mmProps = null;
        boolean sparse = dest.isInSparseFormat();
        String value = null;
        IJV cell = new IJV();
        long nnz = 0L;
        if (matrixMarket) {
            value = br.readLine();
            if (value == null || !value.startsWith("%%")) {
                throw new IOException("Error while reading file in MatrixMarket format. Expecting a header line, but encountered, \"" + value + "\".");
            }
            mmProps = FileFormatPropertiesMM.parse(value);
            while ((value = br.readLine()) != null && value.charAt(0) == '%') {
            }
            String[] fields = value.trim().split("\\s+");
            long mm_rlen = Long.parseLong(fields[0]);
            long mm_clen = Long.parseLong(fields[1]);
            if (rlen != mm_rlen || clen != mm_clen) {
                throw new IOException("Unexpected matrix dimensions while reading file in MatrixMarket format. Expecting dimensions [" + rlen + " rows, " + clen + " cols] but encountered [" + mm_rlen + " rows, " + mm_clen + "cols].");
            }
        }
        try {
            FastStringTokenizer st = new FastStringTokenizer(' ');
            if (sparse) {
                while ((value = br.readLine()) != null) {
                    cell = ReaderTextCell.parseCell(value.toString(), st, cell, mmProps);
                    ReaderTextCell.appendCell(cell, dest, mmProps);
                }
                dest.sortSparseRows();
            } else {
                DenseBlock a = dest.getDenseBlock();
                while ((value = br.readLine()) != null) {
                    cell = ReaderTextCell.parseCell(value.toString(), st, cell, mmProps);
                    nnz += (long)ReaderTextCell.appendCell(cell, a, mmProps);
                }
                dest.setNonZeros(nnz);
            }
        }
        catch (Exception ex) {
            if (cell.getI() < 0 || (long)(cell.getI() + 1) > rlen || cell.getJ() < 0 || (long)(cell.getJ() + 1) > clen) {
                throw new IOException("Matrix cell [" + (cell.getI() + 1) + "," + (cell.getJ() + 1) + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].", ex);
            }
            throw new IOException("Unable to read matrix in raw text cell format.", ex);
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
    }
}

