/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.optim;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.optim.adam.Init_output;
import org.apache.sysml.scripts.nn.optim.adam.Update_output;

public class Adam
extends Script {
    public Adam() {
        String string = "scripts/nn/optim/adam.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object) {
        String string = "source('scripts/nn/optim/adam.dml') as mlcontextns;[m, v] = mlcontextns::init(X);";
        Script script = new Script(string);
        script.in("X", object).out("m").out("v");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("m");
        Matrix matrix2 = mLResults.getMatrix("v");
        Init_output init_output = new Init_output(matrix, matrix2);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] m, matrix[double] v) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - m: Initial state containing the 1st moment (mean) estimate by\n   *      maintaining exponential moving averages of the gradients, of\n   *      same shape as `X`.\n   *  - v: Initial state containing the 2nd raw moment (uncentered\n   *      variance) estimate by maintaining exponential moving averages\n   *      of the squared gradients, of same shape as `X`.\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] m, matrix[double] v) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - m: Initial state containing the 1st moment (mean) estimate by\n   *      maintaining exponential moving averages of the gradients, of\n   *      same shape as `X`.\n   *  - v: Initial state containing the 2nd raw moment (uncentered\n   *      variance) estimate by maintaining exponential moving averages\n   *      of the squared gradients, of same shape as `X`.\n   */\n  m = matrix(0, rows=nrow(X), cols=ncol(X))\n  v = matrix(0, rows=nrow(X), cols=ncol(X))\n}\n";
        return string;
    }

    public Update_output update(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        String string = "source('scripts/nn/optim/adam.dml') as mlcontextns;[X, m, v] = mlcontextns::update(X, dX, lr, beta1, beta2, epsilon, t, m, v);";
        Script script = new Script(string);
        script.in("X", object).in("dX", object2).in("lr", object3).in("beta1", object4).in("beta2", object5).in("epsilon", object6).in("t", object7).in("m", object8).in("v", object9).out("X").out("m").out("v");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("X");
        Matrix matrix2 = mLResults.getMatrix("m");
        Matrix matrix3 = mLResults.getMatrix("v");
        Update_output update_output = new Update_output(matrix, matrix2, matrix3);
        return update_output;
    }

    public String update__docs() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double beta1, double beta2,\n                  double epsilon, int t, matrix[double] m, matrix[double] v)\n    return (matrix[double] X, matrix[double] m, matrix[double] v) {\n  /*\n   * Performs an Adam update.\n   *\n   * Reference:\n   *  - Adam: A Method for Stochastic Optimization, Kingma, Ba.\n   *    - http://arxiv.org/abs/1412.6980\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.  Recommended value is 0.001.\n   *  - beta1: Exponential decay rate for the 1st moment estimates.\n   *      Recommended value is 0.9.\n   *  - beta2: Exponential decay rate for the 2nd moment estimates.\n   *      Recommended value is 0.999.\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Recommended value is 1e-8.\n   *  - t: Timestep, starting at 0.\n   *  - m: State containing the 1st moment (mean) estimate by\n   *      maintaining exponential moving averages of the gradients, of\n   *      same shape as `X`.\n   *  - v: State containing the 2nd raw moment (uncentered variance)\n   *      estimate by maintaining exponential moving averages of the\n   *      squared gradients, of same shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   *  - m: Updated state containing the 1st moment (mean) estimate by\n   *      maintaining exponential moving averages of the gradients, of\n   *      same shape as `X`.\n   *  - v: Updated state containing the 2nd raw moment (uncentered\n   *      variance) estimate by maintaining exponential moving averages\n   *      of the squared gradients, of same shape as `X`.\n   */\n";
        return string;
    }

    public String update__source() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double beta1, double beta2,\n                  double epsilon, int t, matrix[double] m, matrix[double] v)\n    return (matrix[double] X, matrix[double] m, matrix[double] v) {\n  /*\n   * Performs an Adam update.\n   *\n   * Reference:\n   *  - Adam: A Method for Stochastic Optimization, Kingma, Ba.\n   *    - http://arxiv.org/abs/1412.6980\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.  Recommended value is 0.001.\n   *  - beta1: Exponential decay rate for the 1st moment estimates.\n   *      Recommended value is 0.9.\n   *  - beta2: Exponential decay rate for the 2nd moment estimates.\n   *      Recommended value is 0.999.\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Recommended value is 1e-8.\n   *  - t: Timestep, starting at 0.\n   *  - m: State containing the 1st moment (mean) estimate by\n   *      maintaining exponential moving averages of the gradients, of\n   *      same shape as `X`.\n   *  - v: State containing the 2nd raw moment (uncentered variance)\n   *      estimate by maintaining exponential moving averages of the\n   *      squared gradients, of same shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   *  - m: Updated state containing the 1st moment (mean) estimate by\n   *      maintaining exponential moving averages of the gradients, of\n   *      same shape as `X`.\n   *  - v: Updated state containing the 2nd raw moment (uncentered\n   *      variance) estimate by maintaining exponential moving averages\n   *      of the squared gradients, of same shape as `X`.\n   */\n  t = t + 1\n  m = beta1*m + (1-beta1)*dX  # update biased 1st moment estimate\n  v = beta2*v + (1-beta2)*dX^2  # update biased 2nd raw moment estimate\n  # m = m / (1-beta1^t)  # compute bias-corrected 1st moment estimate\n  # v = v / (1-beta2^t)  # compute bias-corrected 2nd raw moment estimate\n  # X = X - (lr * m / (sqrt(v)+epsilon))  # param update\n  # Simplified for computational efficiency:\n  lr = lr * sqrt(1-beta2^t) / (1-beta1^t)\n  X = X - (lr * m / (sqrt(v)+epsilon))\n}\n";
        return string;
    }
}

