/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Objects;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="key")
public abstract class AbstractEntity
implements Entity {
    private static final long serialVersionUID = -9017214159540857901L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractEntity.class);

    protected void checkType(Object object, Class<?> clazz) {
        if (object != null && !clazz.isInstance(object)) {
            throw new ClassCastException("Expected " + clazz.getName() + ", got " + object.getClass().getName());
        }
    }

    protected void checkImplementationType(Implementation object, String expected) {
        if (object != null && !object.getType().equals(expected)) {
            throw new ClassCastException("Expected " + expected + ", got " + object.getType());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractEntity)) {
            return false;
        }
        AbstractEntity entity = (AbstractEntity)obj;
        return Objects.equals(this.getKey(), entity.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.getKey() + ']';
    }
}

