/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;

public class StaticWhitelist
extends EnumeratingWhitelist {
    private static final String[] PERMANENTLY_BLACKLISTED_METHODS = new String[]{"method java.lang.Runtime exit int", "method java.lang.Runtime halt int"};
    private static final String[] PERMANENTLY_BLACKLISTED_STATIC_METHODS = new String[]{"staticMethod java.lang.System exit int", "staticMethod java.lang.System getProperties", "staticMethod java.lang.System getProperty java.lang.String", "staticMethod java.lang.System getProperty java.lang.String java.lang.String", "staticMethod java.lang.System getenv", "staticMethod java.lang.System getenv java.lang.String"};
    private static final String[] PERMANENTLY_BLACKLISTED_CONSTRUCTORS = new String[]{"new org.kohsuke.groovy.sandbox.impl.Checker$SuperConstructorWrapper java.lang.Object[]", "new org.kohsuke.groovy.sandbox.impl.Checker$ThisConstructorWrapper java.lang.Object[]"};
    private final List<EnumeratingWhitelist.MethodSignature> methodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    private final List<EnumeratingWhitelist.NewSignature> newSignatures = new ArrayList<EnumeratingWhitelist.NewSignature>();
    private final List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    private final List<EnumeratingWhitelist.FieldSignature> fieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();
    private final List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();

    public StaticWhitelist(Reader definition) throws IOException {
        try (BufferedReader br = new BufferedReader(definition);){
            List lines = br.lines().map(StaticWhitelist::filter).filter(Objects::nonNull).collect(Collectors.toList());
            for (String line : lines) {
                this.add(line);
            }
        }
    }

    public StaticWhitelist(Collection<? extends String> lines) throws IOException {
        for (String string : lines) {
            this.add(string);
        }
    }

    public StaticWhitelist(String ... lines) throws IOException {
        this(Arrays.asList(lines));
    }

    static String filter(String line) {
        String trimmed = line.trim();
        if (trimmed.isEmpty() || trimmed.startsWith("#")) {
            return null;
        }
        return trimmed;
    }

    public static boolean isPermanentlyBlacklistedMethod(Method m) {
        String signature = StaticWhitelist.canonicalMethodSig(m);
        for (String s : PERMANENTLY_BLACKLISTED_METHODS) {
            if (!s.equals(signature)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPermanentlyBlacklistedStaticMethod(Method m) {
        String signature = StaticWhitelist.canonicalStaticMethodSig(m);
        for (String s : PERMANENTLY_BLACKLISTED_STATIC_METHODS) {
            if (!s.equals(signature)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPermanentlyBlacklistedConstructor(Constructor<?> c) {
        String signature = StaticWhitelist.canonicalConstructorSig(c);
        for (String s : PERMANENTLY_BLACKLISTED_CONSTRUCTORS) {
            if (!s.equals(signature)) continue;
            return true;
        }
        return false;
    }

    public static EnumeratingWhitelist.Signature parse(String line) throws IOException {
        String[] toks = line.split(" ");
        switch (toks[0]) {
            case "method": {
                if (toks.length < 3) {
                    throw new IOException(line);
                }
                return new EnumeratingWhitelist.MethodSignature(toks[1], toks[2], Arrays.copyOfRange(toks, 3, toks.length));
            }
            case "new": {
                if (toks.length < 2) {
                    throw new IOException(line);
                }
                return new EnumeratingWhitelist.NewSignature(toks[1], Arrays.copyOfRange(toks, 2, toks.length));
            }
            case "staticMethod": {
                if (toks.length < 3) {
                    throw new IOException(line);
                }
                return new EnumeratingWhitelist.StaticMethodSignature(toks[1], toks[2], Arrays.copyOfRange(toks, 3, toks.length));
            }
            case "field": {
                if (toks.length != 3) {
                    throw new IOException(line);
                }
                return new EnumeratingWhitelist.FieldSignature(toks[1], toks[2]);
            }
            case "staticField": {
                if (toks.length != 3) {
                    throw new IOException(line);
                }
                return new EnumeratingWhitelist.StaticFieldSignature(toks[1], toks[2]);
            }
        }
        throw new IOException(line);
    }

    public static boolean isPermanentlyBlacklisted(String signature) {
        for (String s : PERMANENTLY_BLACKLISTED_METHODS) {
            if (!s.equals(signature)) continue;
            return true;
        }
        for (String s : PERMANENTLY_BLACKLISTED_STATIC_METHODS) {
            if (!s.equals(signature)) continue;
            return true;
        }
        for (String s : PERMANENTLY_BLACKLISTED_CONSTRUCTORS) {
            if (!s.equals(signature)) continue;
            return true;
        }
        return false;
    }

    private void add(String line) throws IOException {
        EnumeratingWhitelist.Signature s = StaticWhitelist.parse(line);
        if (s instanceof EnumeratingWhitelist.StaticMethodSignature) {
            this.staticMethodSignatures.add((EnumeratingWhitelist.StaticMethodSignature)s);
        } else if (s instanceof EnumeratingWhitelist.MethodSignature) {
            this.methodSignatures.add((EnumeratingWhitelist.MethodSignature)s);
        } else if (s instanceof EnumeratingWhitelist.StaticFieldSignature) {
            this.staticFieldSignatures.add((EnumeratingWhitelist.StaticFieldSignature)s);
        } else if (s instanceof EnumeratingWhitelist.FieldSignature) {
            this.fieldSignatures.add((EnumeratingWhitelist.FieldSignature)s);
        } else {
            this.newSignatures.add((EnumeratingWhitelist.NewSignature)s);
        }
    }

    public static StaticWhitelist from(URL definition) throws IOException {
        try (InputStream is = definition.openStream();){
            StaticWhitelist staticWhitelist = new StaticWhitelist(new InputStreamReader(is, StandardCharsets.UTF_8));
            return staticWhitelist;
        }
    }

    @Override
    protected List<EnumeratingWhitelist.MethodSignature> methodSignatures() {
        return this.methodSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.NewSignature> newSignatures() {
        return this.newSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures() {
        return this.staticMethodSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.FieldSignature> fieldSignatures() {
        return this.fieldSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures() {
        return this.staticFieldSignatures;
    }

    public static SecurityException rejectMethod(Method m) {
        assert ((m.getModifiers() & 8) == 0);
        return StaticWhitelist.reject("method " + EnumeratingWhitelist.getName(m.getDeclaringClass()) + " " + m.getName() + StaticWhitelist.printArgumentTypes(m.getParameterTypes()));
    }

    public static SecurityException rejectMethod(Method m, String info) {
        assert ((m.getModifiers() & 8) == 0);
        return StaticWhitelist.reject("method " + EnumeratingWhitelist.getName(m.getDeclaringClass()) + " " + m.getName() + StaticWhitelist.printArgumentTypes(m.getParameterTypes()) + " (" + info + ")");
    }

    public static SecurityException rejectNew(Constructor<?> c) {
        return StaticWhitelist.reject("new " + EnumeratingWhitelist.getName(c.getDeclaringClass()) + StaticWhitelist.printArgumentTypes(c.getParameterTypes()));
    }

    public static SecurityException rejectStaticMethod(Method m) {
        assert ((m.getModifiers() & 8) != 0);
        return StaticWhitelist.reject("staticMethod " + EnumeratingWhitelist.getName(m.getDeclaringClass()) + " " + m.getName() + StaticWhitelist.printArgumentTypes(m.getParameterTypes()));
    }

    public static SecurityException rejectField(Field f) {
        assert ((f.getModifiers() & 8) == 0);
        return StaticWhitelist.reject("field " + EnumeratingWhitelist.getName(f.getDeclaringClass()) + " " + f.getName());
    }

    public static SecurityException rejectStaticField(Field f) {
        assert ((f.getModifiers() & 8) != 0);
        return StaticWhitelist.reject("staticField " + EnumeratingWhitelist.getName(f.getDeclaringClass()) + " " + f.getName());
    }

    private static SecurityException reject(String detail) {
        return new SecurityException("Insecure call to '" + detail + "' you can tweak the security sandbox to allow it. Read more about this in the documentation.");
    }

    private static String printArgumentTypes(Class<?>[] parameterTypes) {
        StringBuilder b = new StringBuilder();
        for (Class<?> c : parameterTypes) {
            b.append(' ');
            b.append(EnumeratingWhitelist.getName(c));
        }
        return b.toString();
    }
}

