/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.lib.util.collections.AbstractReferenceMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;

public interface QueryStatistics<T>
extends Serializable {
    public Set<T> keys();

    public void recordExecution(T var1);

    public void recordEviction(T var1);

    public long getExecutionCount();

    public long getTotalExecutionCount();

    public long getExecutionCount(T var1);

    public long getTotalExecutionCount(T var1);

    public long getHitCount();

    public long getTotalHitCount();

    public long getHitCount(T var1);

    public long getTotalHitCount(T var1);

    public long getEvictionCount();

    public long getTotalEvictionCount();

    public Date since();

    public Date start();

    public void reset();

    public void clear();

    public void dump(PrintStream var1);

    public static class None<T>
    implements QueryStatistics<T> {
        private static final long serialVersionUID = 1L;
        private Date start;
        private Date since;

        public None() {
            this.since = this.start = new Date();
        }

        @Override
        public void clear() {
        }

        @Override
        public void dump(PrintStream out) {
        }

        @Override
        public long getExecutionCount() {
            return 0L;
        }

        @Override
        public long getExecutionCount(T query) {
            return 0L;
        }

        @Override
        public long getHitCount() {
            return 0L;
        }

        @Override
        public long getHitCount(T query) {
            return 0L;
        }

        @Override
        public long getTotalExecutionCount() {
            return 0L;
        }

        @Override
        public long getTotalExecutionCount(T query) {
            return 0L;
        }

        @Override
        public long getTotalHitCount() {
            return 0L;
        }

        @Override
        public long getTotalHitCount(T query) {
            return 0L;
        }

        @Override
        public long getEvictionCount() {
            return 0L;
        }

        @Override
        public long getTotalEvictionCount() {
            return 0L;
        }

        @Override
        public Set<T> keys() {
            return Collections.emptySet();
        }

        @Override
        public void recordExecution(T query) {
        }

        @Override
        public void reset() {
            this.since = this.start = new Date();
        }

        @Override
        public Date since() {
            return this.since;
        }

        @Override
        public Date start() {
            return this.start;
        }

        @Override
        public void recordEviction(T query) {
        }
    }

    public static class Default<T>
    implements QueryStatistics<T> {
        private static final long serialVersionUID = 1L;
        private static final int FIXED_SIZE = 1000;
        private static final float LOAD_FACTOR = 0.75f;
        private static final int CONCURRENCY = 16;
        private static final int ARRAY_SIZE = 3;
        private static final int READ = 0;
        private static final int HIT = 1;
        private static final int EVICT = 2;
        private long[] astat = new long[3];
        private long[] stat = new long[3];
        private Map<T, long[]> stats;
        private Map<T, long[]> astats;
        private Date start;
        private Date since = this.start = new Date();

        public Default() {
            this.initializeMaps();
        }

        private void initializeMaps() {
            ConcurrentReferenceHashMap statsMap = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.HARD, 16, 0.75f);
            statsMap.setMaxSize(1000);
            this.stats = statsMap;
            ConcurrentReferenceHashMap aStatsMap = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.HARD, 16, 0.75f);
            aStatsMap.setMaxSize(1000);
            this.astats = aStatsMap;
        }

        @Override
        public Set<T> keys() {
            return this.stats.keySet();
        }

        @Override
        public long getExecutionCount() {
            return this.stat[0];
        }

        @Override
        public long getTotalExecutionCount() {
            return this.astat[0];
        }

        @Override
        public long getExecutionCount(T query) {
            return this.getCount(this.stats, query, 0);
        }

        @Override
        public long getTotalExecutionCount(T query) {
            return this.getCount(this.astats, query, 0);
        }

        @Override
        public long getHitCount() {
            return this.stat[1];
        }

        @Override
        public long getTotalHitCount() {
            return this.astat[1];
        }

        @Override
        public long getHitCount(T query) {
            return this.getCount(this.stats, query, 1);
        }

        @Override
        public long getTotalHitCount(T query) {
            return this.getCount(this.astats, query, 1);
        }

        private long getCount(Map<T, long[]> target, T query, int i) {
            long[] row = target.get(query);
            return row == null ? 0L : row[i];
        }

        @Override
        public Date since() {
            return this.since;
        }

        @Override
        public Date start() {
            return this.start;
        }

        @Override
        public synchronized void reset() {
            this.stat = new long[3];
            this.stats.clear();
            this.since = new Date();
        }

        @Override
        public synchronized void clear() {
            this.astat = new long[3];
            this.stat = new long[3];
            this.initializeMaps();
            this.since = this.start = new Date();
        }

        private void addSample(T query, int index) {
            int n = index;
            this.stat[n] = this.stat[n] + 1L;
            int n2 = index;
            this.astat[n2] = this.astat[n2] + 1L;
            this.addSample(this.stats, query, index);
            this.addSample(this.astats, query, index);
        }

        private void addSample(Map<T, long[]> target, T query, int i) {
            long[] row = target.get(query);
            if (row == null) {
                row = new long[3];
            }
            int n = i;
            row[n] = row[n] + 1L;
            target.put(query, row);
        }

        @Override
        public void recordExecution(T query) {
            if (query == null) {
                return;
            }
            boolean cached = this.astats.containsKey(query);
            this.addSample(query, 0);
            if (cached) {
                this.addSample(query, 1);
            }
        }

        @Override
        public void recordEviction(T query) {
            if (query == null) {
                return;
            }
            this.addSample(query, 2);
        }

        @Override
        public void dump(PrintStream out) {
            String header = "Query Statistics starting from " + this.start;
            out.print(header);
            if (this.since == this.start) {
                out.println();
                out.println("Total Query Execution: " + this.toString(this.astat));
                out.println("\tTotal \t\tQuery");
            } else {
                out.println(" last reset on " + this.since);
                out.println("Total Query Execution since start " + this.toString(this.astat) + " since reset " + this.toString(this.stat));
                out.println("\tSince Start \tSince Reset \t\tQuery");
            }
            int i = 0;
            for (T key : this.stats.keySet()) {
                ++i;
                long[] arow = this.astats.get(key);
                if (this.since == this.start) {
                    out.println(i + ". \t" + this.toString(arow) + " \t" + key);
                    continue;
                }
                long[] row = this.stats.get(key);
                out.println(i + ". \t" + this.toString(arow) + " \t" + this.toString(row) + " \t\t" + key);
            }
        }

        long pct(long per, long cent) {
            if (cent <= 0L) {
                return 0L;
            }
            return 100L * per / cent;
        }

        String toString(long[] row) {
            return row[0] + ":" + row[1] + "(" + this.pct(row[1], row[0]) + "%)";
        }

        @Override
        public long getEvictionCount() {
            return this.stat[2];
        }

        @Override
        public long getTotalEvictionCount() {
            return this.astat[2];
        }
    }
}

