/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;

public class EventSubProcessJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        EventSubProcessJsonConverter.fillJsonTypes(convertersToBpmnMap);
        EventSubProcessJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("EventSubProcess", EventSubProcessJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(EventSubProcess.class, EventSubProcessJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "EventSubProcess";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        SubProcess subProcess = (SubProcess)baseElement;
        propertiesNode.put("activitytype", "Event-Sub-Process");
        propertiesNode.put("subprocesstype", "Embedded");
        ArrayNode subProcessShapesArrayNode = this.objectMapper.createArrayNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(subProcess.getId());
        this.processor.processFlowElements((FlowElementsContainer)subProcess, this.model, subProcessShapesArrayNode, converterContext, graphicInfo.getX(), graphicInfo.getY());
        this.flowElementNode.set("childShapes", (JsonNode)subProcessShapesArrayNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        EventSubProcess subProcess = new EventSubProcess();
        JsonNode childShapesArray = elementNode.get("childShapes");
        this.processor.processJsonElements(childShapesArray, modelNode, (BaseElement)subProcess, shapeMap, converterContext, this.model);
        return subProcess;
    }
}

