/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.eventing.builders;

import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.eventing.SynapseSubscription;
import org.wso2.eventing.Subscription;

public class ResponseMessageBuilder {
    private SOAPFactory factory;
    private static final Log log = LogFactory.getLog(ResponseMessageBuilder.class);

    public ResponseMessageBuilder(MessageContext messageCtx) {
        this.factory = (SOAPFactory)messageCtx.getEnvelope().getOMFactory();
    }

    public SOAPEnvelope genSubscriptionResponse(SynapseSubscription subscription) {
        SOAPEnvelope message = this.factory.getDefaultEnvelope();
        EndpointReference subscriptionManagerEPR = new EndpointReference(subscription.getSubManUrl());
        subscriptionManagerEPR.addReferenceParameter(new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier", "wse"), subscription.getId());
        OMNamespace eventingNamespace = this.factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/08/eventing", "wse");
        OMElement subscribeResponseElement = this.factory.createOMElement("SubscribeResponse", eventingNamespace);
        try {
            OMElement subscriptionManagerElement = EndpointReferenceHelper.toOM((OMFactory)subscribeResponseElement.getOMFactory().getMetaFactory().getOMFactory(), (EndpointReference)subscriptionManagerEPR, (QName)new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "SubscriptionManager", "wse"), (String)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
            subscribeResponseElement.addChild((OMNode)subscriptionManagerElement);
            message.getBody().addChild((OMNode)subscribeResponseElement);
        }
        catch (AxisFault axisFault) {
            this.handleException("unable to create subscription response", (Exception)((Object)axisFault));
        }
        return message;
    }

    public SOAPEnvelope genUnSubscribeResponse(SynapseSubscription subscription) {
        SOAPEnvelope message = this.factory.getDefaultEnvelope();
        OMNamespace eventingNamespace = this.factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/08/eventing", "wse");
        OMElement dummyBody = this.factory.createOMElement("UnsubscribeResponse", eventingNamespace);
        message.getBody().addChild((OMNode)dummyBody);
        return message;
    }

    public SOAPEnvelope genRenewSubscriptionResponse(SynapseSubscription subscription) {
        SOAPEnvelope message = this.factory.getDefaultEnvelope();
        OMNamespace eventingNamespace = this.factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/08/eventing", "wse");
        OMElement renewResponseElement = this.factory.createOMElement("RenewResponse", eventingNamespace);
        OMElement expiresElement = this.factory.createOMElement("Expires", eventingNamespace);
        this.factory.createOMText((OMContainer)expiresElement, ConverterUtil.convertToString((Calendar)subscription.getExpires()));
        renewResponseElement.addChild((OMNode)expiresElement);
        message.getBody().addChild((OMNode)renewResponseElement);
        return message;
    }

    public SOAPEnvelope genGetStatusResponse(Subscription subscription) {
        SOAPEnvelope message = this.factory.getDefaultEnvelope();
        OMNamespace eventingNamespace = this.factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/08/eventing", "wse");
        OMElement renewResponseElement = this.factory.createOMElement("GetStatusResponse", eventingNamespace);
        OMElement expiresElement = this.factory.createOMElement("Expires", eventingNamespace);
        if (subscription.getExpires() != null) {
            this.factory.createOMText((OMContainer)expiresElement, ConverterUtil.convertToString((Calendar)subscription.getExpires()));
        } else {
            this.factory.createOMText((OMContainer)expiresElement, "*");
        }
        renewResponseElement.addChild((OMNode)expiresElement);
        message.getBody().addChild((OMNode)renewResponseElement);
        return message;
    }

    public SOAPEnvelope genFaultResponse(MessageContext messageCtx, String code, String subCode, String reason, String detail) {
        SOAPFactory soapFactory = null;
        if (messageCtx.isSOAP11()) {
            soapFactory = OMAbstractFactory.getSOAP11Factory();
            SOAPEnvelope message = soapFactory.getDefaultFaultEnvelope();
            SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason();
            soapFaultReason.setText(reason);
            message.getBody().getFault().setReason(soapFaultReason);
            SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode();
            QName qNameSubCode = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", subCode, "wse");
            soapFaultCode.setText(qNameSubCode);
            message.getBody().getFault().setCode(soapFaultCode);
            return message;
        }
        soapFactory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope message = soapFactory.getDefaultFaultEnvelope();
        SOAPFaultDetail soapFaultDetail = soapFactory.createSOAPFaultDetail();
        soapFaultDetail.setText(detail);
        message.getBody().getFault().setDetail(soapFaultDetail);
        SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason();
        SOAPFaultText soapFaultText = soapFactory.createSOAPFaultText();
        soapFaultText.setText(reason);
        soapFaultReason.addSOAPText(soapFaultText);
        message.getBody().getFault().setReason(soapFaultReason);
        SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode();
        SOAPFaultValue soapFaultValue = soapFactory.createSOAPFaultValue(soapFaultCode);
        soapFaultValue.setText(code);
        soapFaultCode.setValue(soapFaultValue);
        SOAPFaultSubCode soapFaultSubCode = soapFactory.createSOAPFaultSubCode(soapFaultCode);
        SOAPFaultValue soapFaultValueSub = soapFactory.createSOAPFaultValue(soapFaultSubCode);
        QName qNameSubCode = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", subCode, "wse");
        soapFaultValueSub.setText(qNameSubCode);
        soapFaultSubCode.setValue(soapFaultValueSub);
        soapFaultCode.setSubCode(soapFaultSubCode);
        message.getBody().getFault().setCode(soapFaultCode);
        return message;
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new SynapseException(message, e);
    }
}

