/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.sslcert.crl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.utils.sslcert.CertificateVerificationException;
import org.apache.synapse.transport.utils.sslcert.RevocationStatus;
import org.apache.synapse.transport.utils.sslcert.RevocationVerifier;
import org.apache.synapse.transport.utils.sslcert.crl.CRLCache;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;

public class CRLVerifier
implements RevocationVerifier {
    private static final Log log = LogFactory.getLog(CRLVerifier.class);
    private CRLCache cache;

    public CRLVerifier(CRLCache cache) {
        this.cache = cache;
    }

    @Override
    public RevocationStatus checkRevocationStatus(X509Certificate peerCert, X509Certificate issuerCert) throws CertificateVerificationException {
        List<String> list = this.getCrlDistributionPoints(peerCert);
        for (String crlUrl : list) {
            X509CRL x509CRL;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to get CRL for URL: " + crlUrl));
            }
            if (this.cache != null && (x509CRL = this.cache.getCacheValue(crlUrl)) != null) {
                RevocationStatus status = this.getRevocationStatus(x509CRL, peerCert);
                log.debug((Object)"CRL taken from cache....");
                return status;
            }
            try {
                x509CRL = this.downloadCRLFromWeb(crlUrl);
                if (x509CRL == null) continue;
                if (this.cache != null) {
                    this.cache.setCacheValue(crlUrl, x509CRL);
                }
                return this.getRevocationStatus(x509CRL, peerCert);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Either the url is bad or cannot build X509CRL. Check with the next url in the list.", (Throwable)e);
            }
        }
        throw new CertificateVerificationException("Cannot check revocation status with the certificate");
    }

    private RevocationStatus getRevocationStatus(X509CRL x509CRL, X509Certificate peerCert) {
        if (x509CRL.isRevoked(peerCert)) {
            return RevocationStatus.REVOKED;
        }
        return RevocationStatus.GOOD;
    }

    protected X509CRL downloadCRLFromWeb(String crlURL) throws IOException, CertificateVerificationException {
        InputStream crlStream = null;
        try {
            URL url = new URL(crlURL);
            crlStream = url.openStream();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL x509CRL = (X509CRL)cf.generateCRL(crlStream);
            return x509CRL;
        }
        catch (MalformedURLException e) {
            throw new CertificateVerificationException("CRL Url is malformed", e);
        }
        catch (IOException e) {
            throw new CertificateVerificationException("Cant reach URI: " + crlURL + " - only support HTTP", e);
        }
        catch (CertificateException e) {
            throw new CertificateVerificationException(e);
        }
        catch (CRLException e) {
            throw new CertificateVerificationException("Cannot generate X509CRL from the stream data", e);
        }
        finally {
            if (crlStream != null) {
                crlStream.close();
            }
        }
    }

    private List<String> getCrlDistributionPoints(X509Certificate cert) throws CertificateVerificationException {
        CRLDistPoint distPoint;
        byte[] crlDPExtensionValue = cert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId());
        if (crlDPExtensionValue == null) {
            throw new CertificateVerificationException("Certificate doesn't have CRL distribution points");
        }
        ASN1InputStream asn1In = new ASN1InputStream(crlDPExtensionValue);
        try {
            DEROctetString crlDEROctetString = (DEROctetString)asn1In.readObject();
            ASN1InputStream asn1InOctets = new ASN1InputStream(crlDEROctetString.getOctets());
            ASN1Primitive asn1Primitive = asn1InOctets.readObject();
            distPoint = CRLDistPoint.getInstance((Object)asn1Primitive);
        }
        catch (IOException e) {
            throw new CertificateVerificationException("Cannot read certificate to get CRL urls", e);
        }
        ArrayList<String> crlUrls = new ArrayList<String>();
        for (DistributionPoint dp : distPoint.getDistributionPoints()) {
            GeneralName[] genNames;
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            for (GeneralName genName : genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames()) {
                if (genName.getTagNo() != 6) continue;
                String url = DERIA5String.getInstance((Object)genName.getName()).getString().trim();
                crlUrls.add(url);
            }
        }
        if (crlUrls.isEmpty()) {
            throw new CertificateVerificationException("Cant get CRL urls from certificate");
        }
        return crlUrls;
    }
}

