/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.DynamicIntroductionAdvice;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInfo;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupportListener;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.HashMapCachingAdvisorChainFactory;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AdvisedSupport
extends ProxyConfig
implements Advised {
    public static final TargetSource EMPTY_TARGET_SOURCE = EmptyTargetSource.INSTANCE;
    private transient List listeners = new LinkedList();
    TargetSource targetSource = EMPTY_TARGET_SOURCE;
    transient AdvisorChainFactory advisorChainFactory;
    private List advisors = new LinkedList();
    private Advisor[] advisorArray = new Advisor[0];
    private List interfaces = new ArrayList();
    private transient boolean isActive;
    static /* synthetic */ Class class$org$springframework$aop$framework$AdvisedSupport;

    public AdvisedSupport() {
        this.initDefaultAdvisorChainFactory();
    }

    public AdvisedSupport(Class[] interfaces) {
        this();
        this.setInterfaces(interfaces);
    }

    private void initDefaultAdvisorChainFactory() {
        this.setAdvisorChainFactory(new HashMapCachingAdvisorChainFactory());
    }

    public void addListener(AdvisedSupportListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AdvisedSupportListener listener) {
        this.listeners.remove(listener);
    }

    public void setTarget(Object target) {
        this.setTargetSource(new SingletonTargetSource(target));
    }

    public void setTargetSource(TargetSource targetSource) {
        if (this.isActive() && this.isOptimize()) {
            throw new AopConfigException("Can't change target with an optimized CGLIB proxy: it has its own target");
        }
        this.targetSource = targetSource != null ? targetSource : EMPTY_TARGET_SOURCE;
    }

    public TargetSource getTargetSource() {
        return this.targetSource;
    }

    public void setAdvisorChainFactory(AdvisorChainFactory advisorChainFactory) {
        this.advisorChainFactory = advisorChainFactory;
        this.addListener(advisorChainFactory);
    }

    public AdvisorChainFactory getAdvisorChainFactory() {
        return this.advisorChainFactory;
    }

    protected void copyConfigurationFrom(AdvisedSupport other) {
        this.copyConfigurationFrom(other, other.targetSource, other.advisors);
    }

    protected void copyConfigurationFrom(AdvisedSupport other, TargetSource ts, List pAdvisors) {
        this.copyFrom(other);
        this.targetSource = ts;
        this.setInterfaces(other.interfaces.toArray(new Class[other.interfaces.size()]));
        this.advisors = new LinkedList();
        for (int i = 0; i < pAdvisors.size(); ++i) {
            Advisor advice = (Advisor)pAdvisors.get(i);
            this.addAdvisor(advice);
        }
    }

    public void setInterfaces(Class[] interfaces) {
        Assert.notNull((Object)interfaces, (String)"Interfaces must not be null");
        this.interfaces.clear();
        for (int i = 0; i < interfaces.length; ++i) {
            this.addInterface(interfaces[i]);
        }
    }

    public void addInterface(Class newInterface) {
        Assert.notNull((Object)newInterface, (String)"Interface must not be null");
        if (!newInterface.isInterface()) {
            throw new IllegalArgumentException("[" + newInterface.getName() + "] is not an interface");
        }
        if (!this.interfaces.contains(newInterface)) {
            this.interfaces.add(newInterface);
            this.adviceChanged();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Added new aspect interface: " + newInterface.getName()));
            }
        }
    }

    public Class[] getProxiedInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean removeInterface(Class intf) {
        return this.interfaces.remove(intf);
    }

    public void addAdvice(Advice advice) throws AopConfigException {
        int pos = this.advisors != null ? this.advisors.size() : 0;
        this.addAdvice(pos, advice);
    }

    public boolean isInterfaceProxied(Class intf) {
        Iterator it = this.interfaces.iterator();
        while (it.hasNext()) {
            Class proxyIntf = (Class)it.next();
            if (!intf.isAssignableFrom(proxyIntf)) continue;
            return true;
        }
        return false;
    }

    public void addAdvice(int pos, Advice advice) throws AopConfigException {
        if (advice instanceof Interceptor && !(advice instanceof MethodInterceptor)) {
            throw new AopConfigException(this.getClass().getName() + " only handles AOP Alliance MethodInterceptors");
        }
        if (advice instanceof IntroductionInfo) {
            this.addAdvisor(pos, new DefaultIntroductionAdvisor(advice, (IntroductionInfo)((Object)advice)));
        } else {
            if (advice instanceof DynamicIntroductionAdvice) {
                throw new AopConfigException("DynamicIntroductionAdvice may only be added as part of IntroductionAdvisor");
            }
            this.addAdvisor(pos, new DefaultPointcutAdvisor(advice));
        }
    }

    public final boolean removeAdvice(Advice advice) throws AopConfigException {
        int index = this.indexOf(advice);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public int indexOf(Advice advice) {
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (advisor.getAdvice() != advice) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Advisor advisor) {
        return this.advisors.indexOf(advisor);
    }

    public final boolean removeAdvisor(Advisor advisor) {
        int index = this.indexOf(advisor);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public void removeAdvisor(int index) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot remove Advisor: config is frozen");
        }
        if (index < 0 || index > this.advisors.size() - 1) {
            throw new AopConfigException("Advisor index " + index + " is out of bounds: " + "Only have " + this.advisors.size() + " advisors");
        }
        Advisor advisor = (Advisor)this.advisors.get(index);
        if (advisor instanceof IntroductionAdvisor) {
            IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
            for (int j = 0; j < ia.getInterfaces().length; ++j) {
                this.removeInterface(ia.getInterfaces()[j]);
            }
        }
        this.advisors.remove(index);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    private void addAdvisorInternal(int pos, Advisor advice) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: config is frozen");
        }
        if (pos > this.advisors.size()) {
            throw new IllegalArgumentException("Illegal position " + pos + " in advisor list with size " + this.advisors.size());
        }
        this.advisors.add(pos, advice);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    public void addAdvisor(int pos, IntroductionAdvisor advisor) throws AopConfigException {
        advisor.validateInterfaces();
        for (int i = 0; i < advisor.getInterfaces().length; ++i) {
            this.addInterface(advisor.getInterfaces()[i]);
        }
        this.addAdvisorInternal(pos, advisor);
    }

    public void addAdvisor(int pos, Advisor advisor) throws AopConfigException {
        if (advisor instanceof IntroductionAdvisor) {
            this.addAdvisor(pos, (IntroductionAdvisor)advisor);
        } else {
            this.addAdvisorInternal(pos, advisor);
        }
    }

    public void addAdvisor(Advisor advisor) {
        int pos = this.advisors.size();
        this.addAdvisor(pos, advisor);
    }

    private void updateAdvisorArray() {
        this.advisorArray = this.advisors.toArray(new Advisor[this.advisors.size()]);
    }

    public final Advisor[] getAdvisors() {
        return this.advisorArray;
    }

    public final boolean replaceAdvisor(Advisor a, Advisor b) throws AopConfigException {
        int index = this.indexOf(a);
        if (index == -1 || b == null) {
            return false;
        }
        this.removeAdvisor(index);
        this.addAdvisor(index, b);
        return true;
    }

    public final boolean adviceIncluded(Advice advice) {
        if (this.advisors.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (advisor.getAdvice() != advice) continue;
            return true;
        }
        return false;
    }

    public final int countAdvicesOfType(Class interceptorClass) {
        if (this.advisors.size() == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.advisors.size(); ++i) {
            Advisor advisor = (Advisor)this.advisors.get(i);
            if (!interceptorClass.isAssignableFrom(advisor.getAdvice().getClass())) continue;
            ++count;
        }
        return count;
    }

    private synchronized void adviceChanged() {
        if (this.isActive) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((AdvisedSupportListener)this.listeners.get(i)).adviceChanged(this);
            }
        }
    }

    private void activate() {
        this.isActive = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((AdvisedSupportListener)this.listeners.get(i)).activated(this);
        }
    }

    protected synchronized AopProxy createAopProxy() {
        if (!this.isActive) {
            this.activate();
        }
        return this.getAopProxyFactory().createAopProxy(this);
    }

    protected final boolean isActive() {
        return this.isActive;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting " + this));
        }
        AdvisedSupport copy = this;
        if (this.getClass() != (class$org$springframework$aop$framework$AdvisedSupport == null ? (class$org$springframework$aop$framework$AdvisedSupport = AdvisedSupport.class$("org.springframework.aop.framework.AdvisedSupport")) : class$org$springframework$aop$framework$AdvisedSupport)) {
            copy = new AdvisedSupport();
            copy.copyConfigurationFrom(this);
        }
        return copy;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.logger = LogFactory.getLog(this.getClass());
        this.isActive = true;
        this.listeners = new LinkedList();
        this.initDefaultAdvisorChainFactory();
        return this;
    }

    public String toProxyConfigString() {
        return this.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append(this.interfaces.size()).append(" interfaces=[");
        sb.append(AopUtils.interfacesString(this.interfaces));
        sb.append("]; ");
        sb.append(this.advisors.size()).append(" advisors=[");
        sb.append(StringUtils.collectionToDelimitedString((Collection)this.advisors, (String)",", (String)"{", (String)"}")).append("]; ");
        sb.append("targetSource=[").append(this.targetSource).append("]; ");
        sb.append(super.toString());
        sb.append("advisorChainFactory=").append(this.advisorChainFactory);
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

