/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.ClauseFunctionParameterHandler;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

public abstract class SQLBetweenBaseClause
implements JRClauseFunction {
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_BETWEEN_CLAUSE_DB_COLUMN_TOKEN_MISSING = "query.between.clause.db.column.token.missing";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_BETWEEN_CLAUSE_LEFT_PARAMETER_TOKEN_MISSING = "query.between.clause.left.parameter.token.missing";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_BETWEEN_CLAUSE_NAME_TOKEN_MISSING = "query.between.clause.name.token.missing";
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_BETWEEN_CLAUSE_RIGHT_PARAMETER_TOKEN_MISSING = "query.between.clause.right.parameter.token.missing";
    protected static final int POSITION_CLAUSE_ID = 0;
    protected static final int POSITION_DB_COLUMN = 1;
    protected static final int POSITION_LEFT_PARAMETER = 2;
    protected static final int POSITION_RIGHT_PARAMETER = 3;

    @Override
    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String clauseId = clauseTokens.getToken(0);
        String col = clauseTokens.getToken(1);
        String leftParam = clauseTokens.getToken(2);
        String rightParam = clauseTokens.getToken(3);
        if (clauseId == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_BETWEEN_CLAUSE_NAME_TOKEN_MISSING, (Object[])null);
        }
        if (col == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_BETWEEN_CLAUSE_DB_COLUMN_TOKEN_MISSING, (Object[])null);
        }
        if (leftParam == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_BETWEEN_CLAUSE_LEFT_PARAMETER_TOKEN_MISSING, (Object[])null);
        }
        if (rightParam == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_BETWEEN_CLAUSE_RIGHT_PARAMETER_TOKEN_MISSING, (Object[])null);
        }
        ClauseFunctionParameterHandler leftParamHandler = this.createParameterHandler(queryContext, clauseId, leftParam, true);
        ClauseFunctionParameterHandler rightParamHandler = this.createParameterHandler(queryContext, clauseId, rightParam, false);
        StringBuffer sbuffer = queryContext.queryBuffer();
        if (leftParamHandler.hasValue() && rightParamHandler.hasValue()) {
            sbuffer.append("( ");
            this.handleGreaterClause(sbuffer, clauseId, col, leftParamHandler, queryContext);
            sbuffer.append(" AND ");
            this.handleLessClause(sbuffer, clauseId, col, rightParamHandler, queryContext);
            sbuffer.append(" )");
        } else if (!leftParamHandler.hasValue()) {
            if (!rightParamHandler.hasValue()) {
                sbuffer.append("0 = 0");
            } else {
                this.handleLessClause(sbuffer, clauseId, col, rightParamHandler, queryContext);
            }
        } else {
            this.handleGreaterClause(sbuffer, clauseId, col, leftParamHandler, queryContext);
        }
    }

    protected abstract ClauseFunctionParameterHandler createParameterHandler(JRQueryClauseContext var1, String var2, String var3, boolean var4);

    protected String getGreaterOperator(String clauseId) {
        return this.isLeftClosed(clauseId) ? ">=" : ">";
    }

    protected boolean isLeftClosed(String clauseId) {
        return clauseId.startsWith("[");
    }

    protected String getLessOperator(String clauseId) {
        return this.isRightClosed(clauseId) ? "<=" : "<";
    }

    protected boolean isRightClosed(String clauseId) {
        return clauseId.endsWith("]");
    }

    protected void handleGreaterClause(StringBuffer sbuffer, String clauseId, String col, ClauseFunctionParameterHandler leftParamHandler, JRQueryClauseContext queryContext) {
        sbuffer.append(col);
        sbuffer.append(' ');
        sbuffer.append(this.getGreaterOperator(clauseId));
        sbuffer.append(' ');
        sbuffer.append('?');
        leftParamHandler.addQueryParameter();
    }

    protected void handleLessClause(StringBuffer sbuffer, String clauseId, String col, ClauseFunctionParameterHandler rightParamHandler, JRQueryClauseContext queryContext) {
        sbuffer.append(col);
        sbuffer.append(' ');
        sbuffer.append(this.getLessOperator(clauseId));
        sbuffer.append(' ');
        sbuffer.append('?');
        rightParamHandler.addQueryParameter();
    }
}

