/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports7;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.sql.Connection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.StrutsException;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.result.StrutsResultSupport;
import org.apache.struts2.security.NotExcludedAcceptedPatternsChecker;
import org.apache.struts2.util.ValueStack;
import org.apache.struts2.views.jasperreports7.JasperReport7Aware;
import org.apache.struts2.views.jasperreports7.JasperReport7Constants;
import org.apache.struts2.views.jasperreports7.ValueStackDataSource;
import org.apache.struts2.views.jasperreports7.ValueStackShadowMap;
import org.apache.struts2.views.jasperreports7.export.JasperReport7ExporterProvider;

public class JasperReport7Result
extends StrutsResultSupport
implements JasperReport7Constants {
    private static final Logger LOG = LogManager.getLogger(JasperReport7Result.class);
    private String parsedDataSource;
    protected String dataSource;
    protected String format;
    protected String documentName;
    protected String contentDisposition;
    protected String timeZone;
    protected boolean wrapField = true;
    protected String connection;
    protected String reportParameters;
    private String parsedReportParameters;
    private NotExcludedAcceptedPatternsChecker notExcludedAcceptedPatterns;

    @Inject
    public void setNotExcludedAcceptedPatterns(NotExcludedAcceptedPatternsChecker notExcludedAcceptedPatterns) {
        this.notExcludedAcceptedPatterns = notExcludedAcceptedPatterns;
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        JasperPrint jasperPrint;
        Object object;
        this.initializeProperties(invocation);
        LOG.debug("Creating JasperReport for dataSource: {} and format: {}", (Object)this.dataSource, (Object)this.format);
        ValueStack stack = invocation.getStack();
        Connection reportConnection = (Connection)stack.findValue(this.connection);
        ValueStackDataSource reportDataSource = null;
        if (reportConnection == null) {
            reportDataSource = this.prepareDataSource(stack);
        }
        if ((object = invocation.getAction()) instanceof JasperReport7Aware) {
            JasperReport7Aware action = (JasperReport7Aware)object;
            LOG.debug("Passing control to action: {} before generating report", (Object)invocation.getInvocationContext().getActionName());
            action.beforeReportGeneration(invocation);
        }
        ServletContext servletContext = invocation.getInvocationContext().getServletContext();
        String systemId = servletContext.getRealPath(finalLocation);
        ValueStackShadowMap parameters = new ValueStackShadowMap(stack);
        File directory = new File(systemId.substring(0, systemId.lastIndexOf(File.separator)));
        parameters.put("reportDirectory", directory);
        this.applyLocale(invocation, parameters);
        this.applyTimeZone(invocation, parameters);
        this.applyCustomParameters(stack, parameters);
        try {
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((File)new File(systemId));
            jasperPrint = reportConnection == null ? JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)reportDataSource) : JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (Connection)reportConnection);
            Object object2 = invocation.getAction();
            if (object2 instanceof JasperReport7Aware) {
                JasperReport7Aware action = (JasperReport7Aware)object2;
                LOG.debug("Passing control to action: {} after generating report: {}", (Object)invocation.getInvocationContext().getActionName(), (Object)jasperReport.getName());
                action.afterReportGeneration(invocation, jasperReport);
            }
        }
        catch (JRException e) {
            LOG.error("Error building report for uri: {}", (Object)systemId, (Object)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        try {
            LOG.debug("Export the print object to the desired output format: {}", (Object)this.format);
            JasperReport7ExporterProvider exporterProvider = (JasperReport7ExporterProvider)invocation.getInvocationContext().getContainer().getInstance(JasperReport7ExporterProvider.class, this.format);
            if (exporterProvider == null) {
                throw new StrutsException("No exporter found for format: " + this.format);
            }
            this.exportReport(invocation, jasperPrint, exporterProvider);
        }
        catch (StrutsException e) {
            LOG.error("Error producing: {} report for uri: {}", (Object)this.format, (Object)systemId, (Object)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (reportConnection != null) {
                    reportConnection.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Could not close db connection properly", (Throwable)e);
            }
        }
    }

    protected ValueStackDataSource prepareDataSource(ValueStack stack) throws ServletException {
        boolean reevaluate;
        boolean evaluated = this.parsedDataSource != null && !this.parsedDataSource.equals(this.dataSource);
        boolean bl = reevaluate = !evaluated || this.isAcceptableExpression(this.parsedDataSource);
        if (reevaluate) {
            return new ValueStackDataSource(stack, this.parsedDataSource, this.wrapField);
        }
        throw new ServletException(String.format("Unaccepted dataSource expression [%s]", this.parsedDataSource));
    }

    protected void applyLocale(ActionInvocation invocation, Map<String, Object> parameters) {
        Locale locale = null;
        Object object = invocation.getAction();
        if (object instanceof JasperReport7Aware) {
            JasperReport7Aware action = (JasperReport7Aware)object;
            locale = action.getReportLocale(invocation);
        }
        if (locale == null) {
            locale = invocation.getInvocationContext().getLocale();
        }
        LOG.debug("Using locale: {} to generate report", (Object)locale);
        parameters.put("REPORT_LOCALE", locale);
    }

    protected void applyTimeZone(ActionInvocation invocation, Map<String, Object> parameters) {
        if (this.timeZone != null) {
            this.timeZone = this.conditionalParse(this.timeZone, invocation);
            LOG.debug("Puts timezone in jasper report parameter: {}", (Object)this.timeZone);
            TimeZone tz = TimeZone.getTimeZone(this.timeZone);
            if (tz != null) {
                parameters.put("REPORT_TIME_ZONE", tz);
            }
        }
    }

    protected void applyCustomParameters(ValueStack stack, Map<String, Object> parameters) {
        Map reportParams;
        boolean evaluated = this.parsedReportParameters != null && !this.parsedReportParameters.equals(this.reportParameters);
        boolean reevaluate = !evaluated || this.isAcceptableExpression(this.parsedReportParameters);
        Map map = reportParams = reevaluate ? (Map)stack.findValue(this.parsedReportParameters) : null;
        if (reportParams != null) {
            LOG.debug("Found report parameters: {}", (Object)reportParams);
            parameters.putAll(reportParams);
        }
    }

    protected void exportReport(ActionInvocation invocation, JasperPrint jasperPrint, JasperReport7ExporterProvider<?> exporterProvider) throws StrutsException {
        HttpServletResponse response = this.prepapreHttpServletResponse(invocation);
        try {
            Object exporter = exporterProvider.createExporter(invocation, jasperPrint);
            LOG.debug("Exporting report: {} as: {} and flushing response stream", (Object)jasperPrint.getName(), (Object)this.format);
            exporter.exportReport();
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            throw new StrutsException((Throwable)e);
        }
    }

    private HttpServletResponse prepapreHttpServletResponse(ActionInvocation invocation) {
        HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
        if (this.contentDisposition != null || this.documentName != null) {
            StringBuilder tmp = new StringBuilder();
            tmp.append(this.contentDisposition == null ? "inline" : this.contentDisposition);
            if (this.documentName != null) {
                tmp.append("; filename=");
                tmp.append(this.documentName);
                tmp.append(".");
                tmp.append(this.format);
            }
            response.setHeader("Content-disposition", tmp.toString());
        }
        return response;
    }

    private void initializeProperties(ActionInvocation invocation) {
        if (this.dataSource == null && this.connection == null) {
            String message = "No dataSource specified...";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        if (this.dataSource != null) {
            this.parsedDataSource = this.conditionalParse(this.dataSource, invocation);
        }
        this.format = this.conditionalParse(this.format, invocation);
        if (StringUtils.isEmpty((CharSequence)this.format)) {
            this.format = "pdf";
        }
        if (this.contentDisposition != null) {
            this.contentDisposition = this.conditionalParse(this.contentDisposition, invocation);
        }
        if (this.documentName != null) {
            this.documentName = this.conditionalParse(this.documentName, invocation);
        }
        this.parsedReportParameters = this.conditionalParse(this.reportParameters, invocation);
    }

    protected boolean isAcceptableExpression(String expression) {
        NotExcludedAcceptedPatternsChecker.IsAllowed isAllowed = this.notExcludedAcceptedPatterns.isAllowed(expression);
        if (isAllowed.isAllowed()) {
            return true;
        }
        LOG.warn("Expression [{}] isn't allowed by pattern [{}]! See Accepted / Excluded patterns at\nhttps://struts.apache.org/security/", (Object)expression, (Object)isAllowed.getAllowedPattern());
        return false;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setWrapField(boolean wrapField) {
        this.wrapField = wrapField;
    }

    public void setReportParameters(String reportParameters) {
        this.reportParameters = reportParameters;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }
}

