/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2.factory;

import org.apache.struts2.ActionContext;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.DefaultActionProxy;
import org.apache.struts2.ServletActionContext;

import java.io.Serial;
import java.util.Locale;

public class StrutsActionProxy extends DefaultActionProxy {

    @Serial
    private static final long serialVersionUID = -2434901249671934080L;

    public StrutsActionProxy(ActionInvocation inv, String namespace, String actionName, String methodName,
                             boolean executeResult, boolean cleanupContext) {
        super(inv, namespace, actionName, methodName, executeResult, cleanupContext);
    }

    @Override
    public String execute() throws Exception {
        ActionContext previous = ActionContext.getContext();
        ActionContext.bind(invocation.getInvocationContext());
        try {
// This is for the new API:
//            return RequestContextImpl.callInContext(invocation, new Callable<String>() {
//                public String call() throws Exception {
//                    return invocation.invoke();
//                }
//            });

            return invocation.invoke();
        } finally {
            if (cleanupContext)
                ActionContext.bind(previous);
        }
    }

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String getErrorMessage() {
        if (namespace != null && !namespace.trim().isEmpty()) {
            String contextPath = ServletActionContext.getRequest().getContextPath();
            return localizedTextProvider.findDefaultText(
                    "struts.exception.missing-package-action.with-context",
                    Locale.getDefault(),
                    new String[]{namespace, actionName, contextPath}
            );
        } else {
            return super.getErrorMessage();
        }
    }

}
