/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignStyle
extends JRBaseStyle {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DEFAULT = "isDefault";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_PARENT_STYLE = "parentStyle";
    public static final String PROPERTY_PARENT_STYLE_NAME_REFERENCE = "parentStyleNameReference";
    public static final String PROPERTY_CONDITIONAL_STYLES = "conditionalStyles";
    private List<JRConditionalStyle> conditionalStylesList = new ArrayList<JRConditionalStyle>();

    @JsonCreator
    public JRDesignStyle() {
        this(JasperDesign.getThreadInstance());
    }

    public JRDesignStyle(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.getEventSupport().firePropertyChange(PROPERTY_NAME, old, this.name);
    }

    public void setDefault(boolean isDefault) {
        boolean old = this.isDefault;
        this.isDefault = isDefault;
        this.getEventSupport().firePropertyChange(PROPERTY_DEFAULT, old, this.isDefault);
    }

    @Override
    public void setParentStyle(JRStyle parentStyle) {
        JRStyle old = this.getStyle();
        super.setParentStyle(parentStyle);
        this.getEventSupport().firePropertyChange(PROPERTY_PARENT_STYLE, old, this.getStyle());
    }

    public void addConditionalStyle(JRConditionalStyle conditionalStyle) {
        this.addConditionalStyle(this.conditionalStylesList.size(), conditionalStyle);
    }

    public void addConditionalStyle(int index, JRConditionalStyle conditionalStyle) {
        this.conditionalStylesList.add(index, conditionalStyle);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CONDITIONAL_STYLES, conditionalStyle, index);
    }

    public boolean removeConditionalStyle(JRConditionalStyle conditionalStyle) {
        int idx = this.conditionalStylesList.indexOf(conditionalStyle);
        if (idx >= 0) {
            this.conditionalStylesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CONDITIONAL_STYLES, conditionalStyle, idx);
            return true;
        }
        return false;
    }

    @Override
    public JRConditionalStyle[] getConditionalStyles() {
        return this.conditionalStylesList.toArray(new JRDesignConditionalStyle[this.conditionalStylesList.size()]);
    }

    @JsonIgnore
    public List<JRConditionalStyle> getConditionalStyleList() {
        return this.conditionalStylesList;
    }

    @JsonSetter
    private void setConditionalStyles(List<JRConditionalStyle> conditionalStyles) {
        if (conditionalStyles != null) {
            for (JRConditionalStyle conditonalStyle : conditionalStyles) {
                this.addConditionalStyle(conditonalStyle);
            }
        }
    }

    @JsonSetter(value="style")
    public void setParentStyleNameReference(String styleName) {
        String old = this.parentStyleNameReference;
        this.parentStyleNameReference = styleName;
        this.getEventSupport().firePropertyChange(PROPERTY_PARENT_STYLE_NAME_REFERENCE, old, this.parentStyleNameReference);
    }

    @Override
    public Object clone() {
        JRDesignStyle clone = (JRDesignStyle)super.clone();
        clone.conditionalStylesList = JRCloneUtils.cloneList(this.conditionalStylesList);
        return clone;
    }
}

