/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.api;

import java.util.Objects;

public class Expression {
    private final String expression;
    private final String language;

    public Expression(String expression, String language) {
        this.expression = expression;
        this.language = language;
    }

    public Expression(String expression) {
        this(expression, null);
    }

    public Expression(Expression toCopy) {
        this.expression = toCopy.expression;
        this.language = toCopy.language;
    }

    public static Expression createExpressionFromDescribedExpression(String describedExpression) {
        if (describedExpression != null) {
            String language = null;
            String expression = describedExpression;
            if (describedExpression.matches("[a-zA-Z0-9]+:.+")) {
                language = describedExpression.substring(0, describedExpression.indexOf(58));
                expression = describedExpression.substring(describedExpression.indexOf(58) + 1);
            }
            return new Expression(expression, language);
        }
        return null;
    }

    public static Expression createExpression(String expression, String language) {
        if (expression != null) {
            return new Expression(expression, language);
        }
        return null;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression exp = (Expression)obj;
        return Objects.equals(this.expression, exp.expression) && Objects.equals(this.language, exp.language);
    }

    public int hashCode() {
        return Objects.hashCode(this.expression) + Objects.hashCode(this.language);
    }

    public String toString() {
        return (this.language == null ? "DEFAULT" : this.language) + ":" + this.expression;
    }
}

