/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.math.BigDecimal;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.NotNegative;

public class NotNegativeCheck
extends AbstractAnnotationCheck<NotNegative> {
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    private static final long serialVersionUID = 1L;

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Number) {
            if (valueToValidate instanceof Float || valueToValidate instanceof Double) {
                return ((Number)valueToValidate).doubleValue() >= 0.0;
            }
            if (valueToValidate instanceof BigDecimal) {
                return ((BigDecimal)valueToValidate).compareTo(ZERO) >= 0;
            }
            return ((Number)valueToValidate).longValue() >= 0L;
        }
        String stringValue = valueToValidate.toString();
        try {
            return Double.parseDouble(stringValue) >= 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

