/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.text;

import com.google.gxp.base.GxpContext;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.text.PlaintextClosure;
import com.google.i18n.Localizable;
import java.io.IOException;

public class PlaintextClosures {
    public static final PlaintextClosure EMPTY = new PlaintextClosure(){

        @Override
        public void write(Appendable out, GxpContext context) {
        }
    };

    private PlaintextClosures() {
    }

    public static final PlaintextClosure fromPlaintext(final String text) {
        Preconditions.checkNotNull(text);
        return new PlaintextClosure(){

            @Override
            public void write(Appendable out, GxpContext gxpContext) throws IOException {
                out.append(text);
            }
        };
    }

    public static final PlaintextClosure fromLocalizable(final Localizable value) {
        Preconditions.checkNotNull(value);
        return new PlaintextClosure(){

            @Override
            public void write(Appendable out, GxpContext gxpContext) throws IOException {
                out.append(value.toString(gxpContext.getLocale()));
            }
        };
    }
}

