/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.ifexpand;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.BadNodePlacementError;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.Util;
import com.google.gxp.compiler.ifexpand.DoubleElseError;
import com.google.gxp.compiler.ifexpand.ElifAfterElseError;
import com.google.gxp.compiler.ifexpand.IfExpandedTree;
import com.google.gxp.compiler.parser.DefaultingParsedElementVisitor;
import com.google.gxp.compiler.parser.GxpNamespace;
import com.google.gxp.compiler.parser.NullElement;
import com.google.gxp.compiler.parser.ParseTree;
import com.google.gxp.compiler.parser.ParsedAttribute;
import com.google.gxp.compiler.parser.ParsedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IfExpander
implements Function<ParseTree, IfExpandedTree> {
    @Override
    public IfExpandedTree apply(ParseTree parseTree) {
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder(parseTree.getAlerts());
        Worker worker = new Worker(alertSetBuilder);
        List<ParsedElement> children = worker.process(parseTree.getChildren());
        return new IfExpandedTree(parseTree.getSourcePosition(), alertSetBuilder.buildAndClear(), children);
    }

    private static class Worker {
        private final AlertSink alertSink;
        private final NormalVisitor normalVisitor = new NormalVisitor();
        private final Function<ParsedElement, ParsedElement> normalFunction = new Function<ParsedElement, ParsedElement>(){

            @Override
            public ParsedElement apply(ParsedElement node) {
                NormalVisitor visitor = Worker.this.normalVisitor;
                return node.acceptVisitor(visitor);
            }
        };

        Worker(AlertSink alertSink) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
        }

        public List<ParsedElement> process(List<ParsedElement> nodes) {
            return Util.map(nodes, this.normalFunction);
        }

        private class IfChildVisitor
        extends BaseVisitor<Void> {
            private List<GxpNamespace.GxpElement> clauses;
            private List<ParsedElement> clauseChildren;
            private ParsedElement clauseFromNode;
            private boolean sawElse;

            IfChildVisitor(GxpNamespace.GxpElement ifNode) {
                this.clauses = Lists.newArrayList();
                this.clauseChildren = Lists.newArrayList();
                this.sawElse = false;
                this.clauseFromNode = ifNode;
            }

            private void flush() {
                if (this.clauseFromNode != null) {
                    this.clauses.add(new GxpNamespace.GxpElement(this.clauseFromNode.getSourcePosition(), this.clauseFromNode.getDisplayName(), this.clauseFromNode.getAttributes(), ImmutableList.copyOf(this.clauseChildren), GxpNamespace.ElementType.CLAUSE));
                    this.clauseFromNode = null;
                    this.clauseChildren = Lists.newArrayList();
                }
            }

            public List<GxpNamespace.GxpElement> get() {
                this.flush();
                return Collections.unmodifiableList(this.clauses);
            }

            protected Void addNodeToCurrentClause(ParsedElement node) {
                this.clauseChildren.add(node.acceptVisitor(Worker.this.normalVisitor));
                return null;
            }

            @Override
            protected Void defaultVisitElement(ParsedElement node) {
                this.addNodeToCurrentClause(node);
                return null;
            }

            @Override
            public Void visitElifElement(GxpNamespace.GxpElement node) {
                if (this.sawElse) {
                    Worker.this.alertSink.add(new ElifAfterElseError(node));
                } else {
                    this.flush();
                    this.clauseFromNode = node;
                }
                this.reportBadChildren(node);
                return null;
            }

            @Override
            public Void visitElseElement(GxpNamespace.GxpElement node) {
                if (this.sawElse) {
                    Worker.this.alertSink.add(new DoubleElseError(node));
                } else {
                    this.flush();
                    this.clauseFromNode = node;
                    this.sawElse = true;
                }
                this.reportBadChildren(node);
                return null;
            }

            private void reportBadChildren(ParsedElement parentNode) {
                for (ParsedElement badNode : parentNode.getChildren()) {
                    Worker.this.alertSink.add(new BadNodePlacementError(badNode, parentNode));
                }
            }

            @Override
            public Void visitIfElement(GxpNamespace.GxpElement node) {
                return this.addNodeToCurrentClause(node);
            }
        }

        private class NormalVisitor
        extends BaseVisitor<ParsedElement> {
            private NormalVisitor() {
            }

            @Override
            protected ParsedElement defaultVisitElement(ParsedElement node) {
                ArrayList<ParsedElement> newChildren = Lists.newArrayList();
                for (ParsedElement child : node.getChildren()) {
                    newChildren.add(child.acceptVisitor(Worker.this.normalVisitor));
                }
                return node.withChildren(newChildren);
            }

            private ParsedElement reportBadNodeAndContinue(Node badNode, Node parentNode) {
                Worker.this.alertSink.add(new BadNodePlacementError(badNode, parentNode));
                return new NullElement(badNode);
            }

            @Override
            public ParsedElement visitElifElement(GxpNamespace.GxpElement node) {
                return this.reportBadNodeAndContinue(node, null);
            }

            @Override
            public ParsedElement visitElseElement(GxpNamespace.GxpElement node) {
                return this.reportBadNodeAndContinue(node, null);
            }

            @Override
            public ParsedElement visitIfElement(GxpNamespace.GxpElement node) {
                List<GxpNamespace.GxpElement> clauses = this.processIfChildren(node);
                List<ParsedAttribute> attrs = Collections.emptyList();
                return new GxpNamespace.GxpElement(node.getSourcePosition(), node.getDisplayName(), attrs, clauses, GxpNamespace.ElementType.COND);
            }

            public Expression visitValue(Expression value) {
                return value;
            }
        }

        private abstract class BaseVisitor<T>
        extends DefaultingParsedElementVisitor<T> {
            private BaseVisitor() {
            }

            protected List<GxpNamespace.GxpElement> processIfChildren(GxpNamespace.GxpElement node) {
                IfChildVisitor ifChildVisitor = new IfChildVisitor(node);
                for (ParsedElement child : node.getChildren()) {
                    child.acceptVisitor(ifChildVisitor);
                }
                return ifChildVisitor.get();
            }
        }
    }
}

