/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.dot;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.dot.GraphRenderer;
import com.google.gxp.compiler.dot.GraphSink;
import com.google.gxp.compiler.dot.NodeShape;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReflectiveGraphRenderer
implements GraphRenderer<Object> {
    private final String graphName;
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(?:get|is)([A-Z])([A-Za-z0-9_]*)$");

    public ReflectiveGraphRenderer(String graphName) {
        this.graphName = Preconditions.checkNotNull(graphName);
    }

    @Override
    public void renderGraph(GraphSink out, Iterable<?> objects) {
        out.digraphStart(this.graphName);
        Worker worker = new Worker(out);
        for (Object object : objects) {
            worker.renderSubgraph(object);
        }
        out.digraphEnd();
    }

    private static String javaEscape(Object o) {
        return o instanceof String ? "\"" + CharEscapers.javaStringEscaper().escape((String)o) + "\"" : CharEscapers.javaStringEscaper().escape(String.valueOf(o));
    }

    private static class Worker {
        private final GraphSink out;
        private Map<Object, String> visited = new IdentityHashMap<Object, String>();
        private final ToStringHandler toStringHandler = new ToStringHandler();
        private final IterableHandler iterableHandler = new IterableHandler();
        private final MapHandler mapHandler = new MapHandler();
        private final ValueObjectHandler valueObjectHandler = new ValueObjectHandler();
        private final MapEntryHandler mapEntryHandler = new MapEntryHandler();

        Worker(GraphSink out) {
            this.out = Preconditions.checkNotNull(out);
        }

        String renderSubgraph(Object object) {
            if (this.visited.containsKey(object)) {
                return this.visited.get(object);
            }
            String nodeId = "n" + this.visited.size();
            this.visited.put(object, nodeId);
            Handler<?> handler = this.getHandler(object.getClass());
            handler.handle(nodeId, object);
            return nodeId;
        }

        private Handler<?> getHandler(Class<?> cls) {
            if (Map.class.isAssignableFrom(cls)) {
                return this.mapHandler;
            }
            if (Map.Entry.class.isAssignableFrom(cls)) {
                return this.mapEntryHandler;
            }
            if (Iterable.class.isAssignableFrom(cls)) {
                return this.iterableHandler;
            }
            if (Node.class.isAssignableFrom(cls)) {
                return this.valueObjectHandler;
            }
            return this.toStringHandler;
        }

        private class MapEntryHandler
        implements Handler<Map.Entry<?, ?>> {
            private MapEntryHandler() {
            }

            @Override
            public boolean isInlinable() {
                return false;
            }

            @Override
            public void handle(String nodeId, Map.Entry<?, ?> entry) {
                Worker.this.out.simpleNode(nodeId, NodeShape.POINT, "");
                Worker.this.out.edge(nodeId, "key", Worker.this.renderSubgraph(entry.getKey()));
                Worker.this.out.edge(nodeId, "value", Worker.this.renderSubgraph(entry.getValue()));
            }
        }

        private class ValueObjectHandler
        implements Handler<Object> {
            private ValueObjectHandler() {
            }

            @Override
            public boolean isInlinable() {
                return false;
            }

            @Override
            public void handle(String nodeId, Object object) {
                LinkedHashMap<String, String> map = Maps.newLinkedHashMap();
                Class<?> cls = object.getClass();
                for (Method method : cls.getMethods()) {
                    Matcher m = GETTER_PATTERN.matcher(method.getName());
                    if (!m.matches() || method.getParameterTypes().length != 0) continue;
                    String propName = m.group(1).toLowerCase() + m.group(2);
                    try {
                        Object propValue = method.invoke(object, new Object[0]);
                        this.handleProperty(nodeId, map, propName, propValue);
                    }
                    catch (IllegalAccessException iax) {
                        map.put(propName, "->" + iax.getClass().getSimpleName());
                    }
                    catch (InvocationTargetException itx) {
                        map.put(propName, "->" + itx.getClass().getSimpleName());
                    }
                }
                Worker.this.out.recordNode(nodeId, map);
            }

            private void handleProperty(String nodeId, Map<String, String> map, String propName, Object propValue) {
                Handler handler;
                Handler handler2 = handler = propValue == null ? null : Worker.this.getHandler(propValue.getClass());
                if (handler == null) {
                    map.put(propName, "= " + ReflectiveGraphRenderer.javaEscape(propValue));
                } else {
                    Worker.this.out.edge(nodeId, propName, Worker.this.renderSubgraph(propValue));
                }
            }
        }

        private class MapHandler
        implements Handler<Map<?, ?>> {
            private MapHandler() {
            }

            @Override
            public boolean isInlinable() {
                return false;
            }

            @Override
            public void handle(String nodeId, Map<?, ?> map) {
                Worker.this.out.simpleNode(nodeId, NodeShape.TRIANGLE, map.getClass().getSimpleName());
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    Worker.this.out.edge(nodeId, null, Worker.this.renderSubgraph(entry));
                }
            }
        }

        private class IterableHandler
        implements Handler<Iterable<?>> {
            private IterableHandler() {
            }

            @Override
            public boolean isInlinable() {
                return false;
            }

            @Override
            public void handle(String nodeId, Iterable<?> iterable) {
                Worker.this.out.simpleNode(nodeId, NodeShape.PARALLELOGRAM, iterable.getClass().getSimpleName());
                int i = 0;
                for (Object item : iterable) {
                    Worker.this.out.edge(nodeId, "[" + i++ + "]", Worker.this.renderSubgraph(item));
                }
            }
        }

        private class ToStringHandler
        implements Handler<Object> {
            private ToStringHandler() {
            }

            @Override
            public boolean isInlinable() {
                return true;
            }

            @Override
            public void handle(String nodeId, Object obj) {
                Worker.this.out.simpleNode(nodeId, NodeShape.PLAIN_TEXT, ReflectiveGraphRenderer.javaEscape(obj));
            }
        }

        private static interface Handler<T> {
            public boolean isInlinable();

            public void handle(String var1, T var2);
        }
    }
}

