/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.schema.Schema;

public class ExceptionExpression
extends Expression {
    private final Kind exceptionType;
    private final String message;

    public ExceptionExpression(SourcePosition sourcePosition, Schema schema, Kind exceptionType, String message) {
        super(sourcePosition, "exception", schema);
        this.exceptionType = Preconditions.checkNotNull(exceptionType);
        this.message = Preconditions.checkNotNull(message);
    }

    public Kind getKind() {
        return this.exceptionType;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitExceptionExpression(this);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof ExceptionExpression && this.equals((ExceptionExpression)that);
    }

    public boolean equals(ExceptionExpression that) {
        return this.equalsExpression(that) && Objects.equal((Object)this.getKind(), (Object)that.getKind()) && Objects.equal(this.getMessage(), that.getMessage());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(new Object[]{this.expressionHashCode(), this.getKind(), this.getMessage()});
    }

    public static enum Kind {
        NOT_SUPPORTED_IN_SGML_MODE;

    }
}

