/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.redis;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisStoreMapper;
import org.apache.storm.redis.trident.state.RedisClusterState;
import org.apache.storm.redis.trident.state.RedisClusterStateUpdater;
import org.apache.storm.redis.trident.state.RedisState;
import org.apache.storm.redis.trident.state.RedisStateUpdater;
import org.apache.storm.sql.runtime.DataSource;
import org.apache.storm.sql.runtime.DataSourcesProvider;
import org.apache.storm.sql.runtime.FieldInfo;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.ISqlTridentDataSource;
import org.apache.storm.sql.runtime.SimpleSqlTridentConsumer;
import org.apache.storm.sql.runtime.utils.FieldInfoUtils;
import org.apache.storm.sql.runtime.utils.SerdeUtils;
import org.apache.storm.trident.spout.ITridentDataSource;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.tuple.ITuple;
import redis.clients.util.JedisURIHelper;

public class RedisDataSourcesProvider
implements DataSourcesProvider {
    private static final int DEFAULT_REDIS_PORT = 6379;
    private static final int DEFAULT_TIMEOUT = 2000;

    public String scheme() {
        return "redis";
    }

    public DataSource construct(URI uri, String inputFormatClass, String outputFormatClass, List<FieldInfo> fields) {
        throw new UnsupportedOperationException();
    }

    public ISqlTridentDataSource constructTrident(URI uri, String inputFormatClass, String outputFormatClass, Properties props, List<FieldInfo> fields) {
        Preconditions.checkArgument((boolean)JedisURIHelper.isValid((URI)uri), (Object)("URI is not valid for Redis: " + uri));
        String host = uri.getHost();
        int port = uri.getPort() != -1 ? uri.getPort() : 6379;
        int dbIdx = JedisURIHelper.getDBIndex((URI)uri);
        String password = JedisURIHelper.getPassword((URI)uri);
        int timeout = Integer.parseInt(props.getProperty("redis.timeout", String.valueOf(2000)));
        boolean clusterMode = Boolean.valueOf(props.getProperty("use.redis.cluster", "false"));
        List fieldNames = FieldInfoUtils.getFieldNames(fields);
        IOutputSerializer serializer = SerdeUtils.getSerializer((String)outputFormatClass, (Properties)props, (List)fieldNames);
        if (clusterMode) {
            JedisClusterConfig config = new JedisClusterConfig.Builder().setNodes(Collections.singleton(new InetSocketAddress(host, port))).setTimeout(timeout).build();
            return new RedisClusterTridentDataSource(config, props, fields, serializer);
        }
        JedisPoolConfig config = new JedisPoolConfig(host, port, timeout, password, dbIdx);
        return new RedisTridentDataSource(config, props, fields, serializer);
    }

    private static class TridentRedisStoreMapper
    implements RedisStoreMapper {
        private final RedisDataTypeDescription dataTypeDescription;
        private final FieldInfo primaryKeyField;
        private final IOutputSerializer outputSerializer;

        private TridentRedisStoreMapper(RedisDataTypeDescription dataTypeDescription, List<FieldInfo> fields, IOutputSerializer outputSerializer) {
            this.dataTypeDescription = dataTypeDescription;
            this.outputSerializer = outputSerializer;
            FieldInfo pkField = this.findPrimaryKeyField(fields);
            Preconditions.checkArgument((pkField != null ? 1 : 0) != 0, (Object)"Primary key must be presented to field list");
            this.primaryKeyField = pkField;
        }

        private FieldInfo findPrimaryKeyField(List<FieldInfo> fields) {
            FieldInfo pkField = null;
            for (FieldInfo field : fields) {
                if (!field.isPrimary()) continue;
                pkField = field;
                break;
            }
            return pkField;
        }

        public RedisDataTypeDescription getDataTypeDescription() {
            return this.dataTypeDescription;
        }

        public String getKeyFromTuple(ITuple tuple) {
            String keyFieldName = this.primaryKeyField.name();
            Object key = tuple.getValueByField(keyFieldName);
            if (key == null) {
                throw new NullPointerException("key field " + keyFieldName + " is null");
            }
            return String.valueOf(key);
        }

        public String getValueFromTuple(ITuple tuple) {
            byte[] array = this.outputSerializer.write(tuple.getValues(), null).array();
            return new String(array);
        }
    }

    private static class RedisTridentDataSource
    extends AbstractRedisTridentDataSource {
        private final JedisPoolConfig config;

        RedisTridentDataSource(JedisPoolConfig config, Properties props, List<FieldInfo> fields, IOutputSerializer serializer) {
            super(props, fields, serializer);
            this.config = config;
        }

        @Override
        protected StateFactory newStateFactory() {
            return new RedisState.Factory(this.config);
        }

        @Override
        protected StateUpdater newStateUpdater(RedisStoreMapper storeMapper) {
            return new RedisStateUpdater(storeMapper);
        }
    }

    private static class RedisClusterTridentDataSource
    extends AbstractRedisTridentDataSource {
        private final JedisClusterConfig config;

        RedisClusterTridentDataSource(JedisClusterConfig config, Properties props, List<FieldInfo> fields, IOutputSerializer serializer) {
            super(props, fields, serializer);
            this.config = config;
        }

        @Override
        protected StateFactory newStateFactory() {
            return new RedisClusterState.Factory(this.config);
        }

        @Override
        protected StateUpdater newStateUpdater(RedisStoreMapper storeMapper) {
            return new RedisClusterStateUpdater(storeMapper);
        }
    }

    private static abstract class AbstractRedisTridentDataSource
    implements ISqlTridentDataSource,
    Serializable {
        private final Properties props;
        private final List<FieldInfo> fields;
        private final IOutputSerializer serializer;

        protected abstract StateFactory newStateFactory();

        protected abstract StateUpdater newStateUpdater(RedisStoreMapper var1);

        AbstractRedisTridentDataSource(Properties props, List<FieldInfo> fields, IOutputSerializer serializer) {
            this.props = props;
            this.fields = fields;
            this.serializer = serializer;
        }

        public ITridentDataSource getProducer() {
            throw new UnsupportedOperationException(this.getClass().getName() + " doesn't provide Producer");
        }

        public ISqlTridentDataSource.SqlTridentConsumer getConsumer() {
            RedisDataTypeDescription dataTypeDescription = this.getDataTypeDesc(this.props);
            TridentRedisStoreMapper storeMapper = new TridentRedisStoreMapper(dataTypeDescription, this.fields, this.serializer);
            StateFactory stateFactory = this.newStateFactory();
            StateUpdater stateUpdater = this.newStateUpdater(storeMapper);
            return new SimpleSqlTridentConsumer(stateFactory, stateUpdater);
        }

        private RedisDataTypeDescription getDataTypeDesc(Properties props) {
            Preconditions.checkArgument((boolean)props.containsKey("data.type"), (Object)"Redis data source must contain \"data.type\" config");
            RedisDataTypeDescription.RedisDataType dataType = RedisDataTypeDescription.RedisDataType.valueOf((String)props.getProperty("data.type").toUpperCase());
            String additionalKey = props.getProperty("data.additional.key");
            return new RedisDataTypeDescription(dataType, additionalKey);
        }
    }
}

