/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class MetaTableAccessor {
    private static final Log LOG = LogFactory.getLog(MetaTableAccessor.class);
    static final byte[] META_REGION_PREFIX;
    protected static final char META_REPLICA_ID_DELIMITER = '_';
    private static final Pattern SERVER_COLUMN_PATTERN;

    public static List<Result> fullScanOfMeta(Connection connection) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaTableAccessor.fullScan(connection, v, null);
        return v.getResults();
    }

    public static void fullScan(Connection connection, Visitor visitor) throws IOException {
        MetaTableAccessor.fullScan(connection, visitor, null);
    }

    public static List<Result> fullScan(Connection connection) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaTableAccessor.fullScan(connection, v, null);
        return v.getResults();
    }

    static Table getMetaHTable(Connection connection) throws IOException {
        if (connection == null) {
            throw new NullPointerException("No connection");
        }
        if (connection.isClosed()) {
            throw new IOException("connection is closed");
        }
        if (connection instanceof ClusterConnection && ((ClusterConnection)connection).isManaged()) {
            return new HTable(TableName.META_TABLE_NAME, (ClusterConnection)connection);
        }
        return connection.getTable(TableName.META_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result get(Table t, Get g) throws IOException {
        try {
            Result result = t.get(g);
            return result;
        }
        finally {
            t.close();
        }
    }

    @Deprecated
    public static Pair<HRegionInfo, ServerName> getRegion(Connection connection, byte[] regionName) throws IOException {
        HRegionLocation location = MetaTableAccessor.getRegionLocation(connection, regionName);
        return location == null ? null : new Pair((Object)location.getRegionInfo(), (Object)location.getServerName());
    }

    public static HRegionLocation getRegionLocation(Connection connection, byte[] regionName) throws IOException {
        byte[] row = regionName;
        HRegionInfo parsedInfo = null;
        try {
            parsedInfo = MetaTableAccessor.parseRegionInfoFromRegionName(regionName);
            row = MetaTableAccessor.getMetaKeyForRegion(parsedInfo);
        }
        catch (Exception parseEx) {
            // empty catch block
        }
        Get get = new Get(row);
        get.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
        return locations == null ? null : locations.getRegionLocation(parsedInfo == null ? 0 : parsedInfo.getReplicaId());
    }

    public static HRegionLocation getRegionLocation(Connection connection, HRegionInfo regionInfo) throws IOException {
        byte[] row = MetaTableAccessor.getMetaKeyForRegion(regionInfo);
        Get get = new Get(row);
        get.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        return MetaTableAccessor.getRegionLocation(r, regionInfo, regionInfo.getReplicaId());
    }

    public static byte[] getMetaKeyForRegion(HRegionInfo regionInfo) {
        return RegionReplicaUtil.getRegionInfoForDefaultReplica(regionInfo).getRegionName();
    }

    protected static HRegionInfo parseRegionInfoFromRegionName(byte[] regionName) throws IOException {
        byte[][] fields = HRegionInfo.parseRegionName(regionName);
        long regionId = Long.parseLong(Bytes.toString((byte[])fields[2]));
        int replicaId = fields.length > 3 ? Integer.parseInt(Bytes.toString((byte[])fields[3]), 16) : 0;
        return new HRegionInfo(TableName.valueOf((byte[])fields[0]), fields[1], fields[1], false, regionId, replicaId);
    }

    public static Result getRegionResult(Connection connection, byte[] regionName) throws IOException {
        Get get = new Get(regionName);
        get.addFamily(HConstants.CATALOG_FAMILY);
        return MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
    }

    public static Pair<HRegionInfo, HRegionInfo> getRegionsFromMergeQualifier(Connection connection, byte[] regionName) throws IOException {
        Result result = MetaTableAccessor.getRegionResult(connection, regionName);
        HRegionInfo mergeA = MetaTableAccessor.getHRegionInfo(result, HConstants.MERGEA_QUALIFIER);
        HRegionInfo mergeB = MetaTableAccessor.getHRegionInfo(result, HConstants.MERGEB_QUALIFIER);
        if (mergeA == null && mergeB == null) {
            return null;
        }
        return new Pair((Object)mergeA, (Object)mergeB);
    }

    public static boolean tableExists(Connection connection, final TableName tableName) throws IOException {
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            return true;
        }
        CollectingVisitor<HRegionInfo> visitor = new CollectingVisitor<HRegionInfo>(){
            private HRegionInfo current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
                if (locations == null || locations.getRegionLocation().getRegionInfo() == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                this.current = locations.getRegionLocation().getRegionInfo();
                if (this.current == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                if (!MetaTableAccessor.isInsideTable(this.current, tableName)) {
                    return false;
                }
                super.visit(r);
                return false;
            }

            @Override
            void add(Result r) {
                this.results.add(this.current);
            }
        };
        MetaTableAccessor.fullScan(connection, visitor, MetaTableAccessor.getTableStartRowForMeta(tableName));
        return visitor.getResults().size() >= 1;
    }

    public static List<HRegionInfo> getTableRegions(ZooKeeperWatcher zkw, Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegions(zkw, connection, tableName, false);
    }

    public static List<HRegionInfo> getTableRegions(ZooKeeperWatcher zkw, Connection connection, TableName tableName, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<HRegionInfo, ServerName>> result = null;
        result = MetaTableAccessor.getTableRegionsAndLocations(zkw, connection, tableName, excludeOfflinedSplitParents);
        return MetaTableAccessor.getListOfHRegionInfos(result);
    }

    static List<HRegionInfo> getListOfHRegionInfos(List<Pair<HRegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return null;
        }
        ArrayList<HRegionInfo> result = new ArrayList<HRegionInfo>(pairs.size());
        for (Pair<HRegionInfo, ServerName> pair : pairs) {
            result.add((HRegionInfo)pair.getFirst());
        }
        return result;
    }

    static boolean isInsideTable(HRegionInfo current, TableName tableName) {
        return tableName.equals((Object)current.getTable());
    }

    static byte[] getTableStartRowForMeta(TableName tableName) {
        byte[] startRow = new byte[tableName.getName().length + 2];
        System.arraycopy(tableName.getName(), 0, startRow, 0, tableName.getName().length);
        startRow[startRow.length - 2] = 44;
        startRow[startRow.length - 1] = 44;
        return startRow;
    }

    public static Scan getScanForTableName(TableName tableName) {
        String strName = tableName.getNameAsString();
        byte[] startKey = Bytes.toBytes((String)(strName + ",,"));
        byte[] stopKey = Bytes.toBytes((String)(strName + " ,,"));
        Scan scan = new Scan(startKey);
        scan.setStopRow(stopKey);
        return scan;
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(ZooKeeperWatcher zkw, Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegionsAndLocations(zkw, connection, tableName, true);
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(ZooKeeperWatcher zkw, Connection connection, final TableName tableName, final boolean excludeOfflinedSplitParents) throws IOException {
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            ServerName serverName = new MetaTableLocator().getMetaRegionLocation(zkw);
            ArrayList<Pair<HRegionInfo, ServerName>> list = new ArrayList<Pair<HRegionInfo, ServerName>>();
            list.add(new Pair((Object)HRegionInfo.FIRST_META_REGIONINFO, (Object)serverName));
            return list;
        }
        CollectingVisitor<Pair<HRegionInfo, ServerName>> visitor = new CollectingVisitor<Pair<HRegionInfo, ServerName>>(){
            private RegionLocations current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                this.current = MetaTableAccessor.getRegionLocations(r);
                if (this.current == null || this.current.getRegionLocation().getRegionInfo() == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                HRegionInfo hri = this.current.getRegionLocation().getRegionInfo();
                if (!MetaTableAccessor.isInsideTable(hri, tableName)) {
                    return false;
                }
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                return super.visit(r);
            }

            @Override
            void add(Result r) {
                if (this.current == null) {
                    return;
                }
                for (HRegionLocation loc : this.current.getRegionLocations()) {
                    if (loc == null) continue;
                    this.results.add(new Pair((Object)loc.getRegionInfo(), (Object)loc.getServerName()));
                }
            }
        };
        MetaTableAccessor.fullScan(connection, visitor, MetaTableAccessor.getTableStartRowForMeta(tableName));
        return visitor.getResults();
    }

    public static NavigableMap<HRegionInfo, Result> getServerUserRegions(Connection connection, final ServerName serverName) throws IOException {
        final TreeMap<HRegionInfo, Result> hris = new TreeMap<HRegionInfo, Result>();
        CollectingVisitor<Result> v = new CollectingVisitor<Result>(){

            @Override
            void add(Result r) {
                if (r == null || r.isEmpty()) {
                    return;
                }
                RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
                if (locations == null) {
                    return;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null || loc.getServerName() == null || !loc.getServerName().equals(serverName)) continue;
                    hris.put(loc.getRegionInfo(), r);
                }
            }
        };
        MetaTableAccessor.fullScan(connection, v);
        return hris;
    }

    public static void fullScanMetaAndPrint(Connection connection) throws IOException {
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                LOG.info((Object)("fullScanMetaAndPrint.Current Meta Row: " + r));
                RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
                if (locations == null) {
                    return true;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null) continue;
                    LOG.info((Object)("fullScanMetaAndPrint.HRI Print= " + loc.getRegionInfo()));
                }
                return true;
            }
        };
        MetaTableAccessor.fullScan(connection, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fullScan(Connection connection, Visitor visitor, byte[] startrow) throws IOException {
        Scan scan = new Scan();
        if (startrow != null) {
            scan.setStartRow(startrow);
        }
        if (startrow == null) {
            int caching = connection.getConfiguration().getInt("hbase.meta.scanner.caching", 100);
            scan.setCaching(caching);
        }
        scan.addFamily(HConstants.CATALOG_FAMILY);
        Table metaTable = MetaTableAccessor.getMetaHTable(connection);
        ResultScanner scanner = null;
        try {
            Result data;
            scanner = metaTable.getScanner(scan);
            while ((data = scanner.next()) != null && (data.isEmpty() || visitor.visit(data))) {
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            metaTable.close();
        }
    }

    protected static byte[] getFamily() {
        return HConstants.CATALOG_FAMILY;
    }

    protected static byte[] getRegionInfoColumn() {
        return HConstants.REGIONINFO_QUALIFIER;
    }

    @VisibleForTesting
    public static byte[] getServerColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVER_QUALIFIER : Bytes.toBytes((String)("server_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    public static byte[] getStartCodeColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STARTCODE_QUALIFIER : Bytes.toBytes((String)("serverstartcode_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    public static byte[] getSeqNumColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SEQNUM_QUALIFIER : Bytes.toBytes((String)("seqnumDuringOpen_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    static int parseReplicaIdFromServerColumn(byte[] serverColumn) {
        String serverStr = Bytes.toString((byte[])serverColumn);
        Matcher matcher = SERVER_COLUMN_PATTERN.matcher(serverStr);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String group = matcher.group(1);
            if (group != null && group.length() > 0) {
                return Integer.parseInt(group.substring(1), 16);
            }
            return 0;
        }
        return -1;
    }

    private static ServerName getServerName(Result r, int replicaId) {
        byte[] serverColumn = MetaTableAccessor.getServerColumn(replicaId);
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getFamily(), serverColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
        byte[] startcodeColumn = MetaTableAccessor.getStartCodeColumn(replicaId);
        cell = r.getColumnLatestCell(MetaTableAccessor.getFamily(), startcodeColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        return ServerName.valueOf(hostAndPort, Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    private static long getSeqNumDuringOpen(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getFamily(), MetaTableAccessor.getSeqNumColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
    }

    public static RegionLocations getRegionLocations(Result r) {
        Map.Entry entry;
        if (r == null) {
            return null;
        }
        HRegionInfo regionInfo = MetaTableAccessor.getHRegionInfo(r, MetaTableAccessor.getRegionInfoColumn());
        if (regionInfo == null) {
            return null;
        }
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>(1);
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyMap = r.getNoVersionMap();
        locations.add(MetaTableAccessor.getRegionLocation(r, regionInfo, 0));
        NavigableMap infoMap = (NavigableMap)familyMap.get(MetaTableAccessor.getFamily());
        if (infoMap == null) {
            return new RegionLocations(locations);
        }
        int replicaId = 0;
        byte[] serverColumn = MetaTableAccessor.getServerColumn(replicaId);
        NavigableMap serverMap = infoMap.tailMap(serverColumn, false);
        if (serverMap.isEmpty()) {
            return new RegionLocations(locations);
        }
        Iterator i$ = serverMap.entrySet().iterator();
        while (i$.hasNext() && (replicaId = MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])(entry = i$.next()).getKey())) >= 0) {
            HRegionLocation location = MetaTableAccessor.getRegionLocation(r, regionInfo, replicaId);
            if (location == null || location.getServerName() == null) {
                locations.add(null);
                continue;
            }
            locations.add(location);
        }
        return new RegionLocations(locations);
    }

    private static HRegionLocation getRegionLocation(Result r, HRegionInfo regionInfo, int replicaId) {
        ServerName serverName = MetaTableAccessor.getServerName(r, replicaId);
        long seqNum = MetaTableAccessor.getSeqNumDuringOpen(r, replicaId);
        HRegionInfo replicaInfo = RegionReplicaUtil.getRegionInfoForReplica(regionInfo, replicaId);
        return new HRegionLocation(replicaInfo, serverName, seqNum);
    }

    public static HRegionInfo getHRegionInfo(Result data) {
        return MetaTableAccessor.getHRegionInfo(data, HConstants.REGIONINFO_QUALIFIER);
    }

    private static HRegionInfo getHRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getFamily(), qualifier);
        if (cell == null) {
            return null;
        }
        return HRegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static PairOfSameType<HRegionInfo> getDaughterRegions(Result data) {
        HRegionInfo splitA = MetaTableAccessor.getHRegionInfo(data, HConstants.SPLITA_QUALIFIER);
        HRegionInfo splitB = MetaTableAccessor.getHRegionInfo(data, HConstants.SPLITB_QUALIFIER);
        return new PairOfSameType((Object)splitA, (Object)splitB);
    }

    public static PairOfSameType<HRegionInfo> getMergeRegions(Result data) {
        HRegionInfo mergeA = MetaTableAccessor.getHRegionInfo(data, HConstants.MERGEA_QUALIFIER);
        HRegionInfo mergeB = MetaTableAccessor.getHRegionInfo(data, HConstants.MERGEB_QUALIFIER);
        return new PairOfSameType((Object)mergeA, (Object)mergeB);
    }

    @Deprecated
    public static int getRegionCount(Configuration c, String tableName) throws IOException {
        return MetaTableAccessor.getRegionCount(c, TableName.valueOf((String)tableName));
    }

    public static int getRegionCount(Configuration c, TableName tableName) throws IOException {
        try (Connection connection = ConnectionFactory.createConnection(c);){
            int n = MetaTableAccessor.getRegionCount(connection, tableName);
            return n;
        }
    }

    public static int getRegionCount(Connection connection, TableName tableName) throws IOException {
        try (RegionLocator locator = connection.getRegionLocator(tableName);){
            List<HRegionLocation> locations = locator.getAllRegionLocations();
            int n = locations == null ? 0 : locations.size();
            return n;
        }
    }

    public static Put makePutFromRegionInfo(HRegionInfo regionInfo) throws IOException {
        Put put = new Put(regionInfo.getRegionName());
        MetaTableAccessor.addRegionInfo(put, regionInfo);
        return put;
    }

    public static Delete makeDeleteFromRegionInfo(HRegionInfo regionInfo) {
        if (regionInfo == null) {
            throw new IllegalArgumentException("Can't make a delete for null region");
        }
        Delete delete = new Delete(regionInfo.getRegionName());
        return delete;
    }

    public static Put addDaughtersToPut(Put put, HRegionInfo splitA, HRegionInfo splitB) {
        if (splitA != null) {
            put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, splitA.toByteArray());
        }
        if (splitB != null) {
            put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, splitB.toByteArray());
        }
        return put;
    }

    static void putToMetaTable(Connection connection, Put p) throws IOException {
        MetaTableAccessor.put(MetaTableAccessor.getMetaHTable(connection), p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(Table t, Put p) throws IOException {
        try {
            t.put(p);
        }
        finally {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putsToMetaTable(Connection connection, List<Put> ps) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            t.put(ps);
        }
    }

    static void deleteFromMetaTable(Connection connection, Delete d) throws IOException {
        ArrayList<Delete> dels = new ArrayList<Delete>(1);
        dels.add(d);
        MetaTableAccessor.deleteFromMetaTable(connection, dels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFromMetaTable(Connection connection, List<Delete> deletes) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            t.delete(deletes);
        }
    }

    public static void removeRegionReplicasFromMeta(Set<byte[]> metaRows, int replicaIndexToDeleteFrom, int numReplicasToRemove, Connection connection) throws IOException {
        int absoluteIndex = replicaIndexToDeleteFrom + numReplicasToRemove;
        for (byte[] row : metaRows) {
            Delete deleteReplicaLocations = new Delete(row);
            for (int i = replicaIndexToDeleteFrom; i < absoluteIndex; ++i) {
                deleteReplicaLocations.deleteColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn(i));
                deleteReplicaLocations.deleteColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn(i));
                deleteReplicaLocations.deleteColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn(i));
            }
            MetaTableAccessor.deleteFromMetaTable(connection, deleteReplicaLocations);
        }
    }

    public static void mutateMetaTable(Connection connection, List<Mutation> mutations) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            t.batch(mutations);
        }
    }

    public static void addRegionToMeta(Connection connection, HRegionInfo regionInfo) throws IOException {
        MetaTableAccessor.putToMetaTable(connection, MetaTableAccessor.makePutFromRegionInfo(regionInfo));
        LOG.info((Object)("Added " + regionInfo.getRegionNameAsString()));
    }

    public static void addRegionToMeta(Table meta, HRegionInfo regionInfo) throws IOException {
        MetaTableAccessor.addRegionToMeta(meta, regionInfo, null, null);
    }

    public static void addRegionToMeta(Table meta, HRegionInfo regionInfo, HRegionInfo splitA, HRegionInfo splitB) throws IOException {
        Put put = MetaTableAccessor.makePutFromRegionInfo(regionInfo);
        MetaTableAccessor.addDaughtersToPut(put, splitA, splitB);
        meta.put(put);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added " + regionInfo.getRegionNameAsString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegionToMeta(Connection connection, HRegionInfo regionInfo, HRegionInfo splitA, HRegionInfo splitB) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.addRegionToMeta(meta, regionInfo, splitA, splitB);
        }
    }

    public static void addRegionsToMeta(Connection connection, List<HRegionInfo> regionInfos, int regionReplication) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (HRegionInfo regionInfo : regionInfos) {
            if (!RegionReplicaUtil.isDefaultReplica(regionInfo)) continue;
            puts.add(MetaTableAccessor.makePutFromRegionInfo(regionInfo));
            Put put = MetaTableAccessor.makePutFromRegionInfo(regionInfo);
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(put, i);
            }
            puts.add(put);
        }
        MetaTableAccessor.putsToMetaTable(connection, puts);
        LOG.info((Object)("Added " + puts.size()));
    }

    public static void addDaughter(Connection connection, HRegionInfo regionInfo, ServerName sn, long openSeqNum) throws NotAllMetaRegionsOnlineException, IOException {
        Put put = new Put(regionInfo.getRegionName());
        MetaTableAccessor.addRegionInfo(put, regionInfo);
        if (sn != null) {
            MetaTableAccessor.addLocation(put, sn, openSeqNum, regionInfo.getReplicaId());
        }
        MetaTableAccessor.putToMetaTable(connection, put);
        LOG.info((Object)("Added daughter " + regionInfo.getEncodedName() + (sn == null ? ", serverName=null" : ", serverName=" + sn.toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeRegions(Connection connection, HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB, ServerName sn, int regionReplication) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            HRegionInfo copyOfMerged = new HRegionInfo(mergedRegion);
            Put putOfMerged = MetaTableAccessor.makePutFromRegionInfo(copyOfMerged);
            putOfMerged.addImmutable(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER, regionA.toByteArray());
            putOfMerged.addImmutable(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER, regionB.toByteArray());
            Delete deleteA = MetaTableAccessor.makeDeleteFromRegionInfo(regionA);
            Delete deleteB = MetaTableAccessor.makeDeleteFromRegionInfo(regionB);
            MetaTableAccessor.addLocation(putOfMerged, sn, 1L, mergedRegion.getReplicaId());
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(putOfMerged, i);
            }
            byte[] tableRow = Bytes.toBytes((String)(mergedRegion.getRegionNameAsString() + 44));
            MetaTableAccessor.multiMutate(meta, tableRow, putOfMerged, deleteA, deleteB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitRegion(Connection connection, HRegionInfo parent, HRegionInfo splitA, HRegionInfo splitB, ServerName sn, int regionReplication) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            HRegionInfo copyOfParent = new HRegionInfo(parent);
            copyOfParent.setOffline(true);
            copyOfParent.setSplit(true);
            Put putParent = MetaTableAccessor.makePutFromRegionInfo(copyOfParent);
            MetaTableAccessor.addDaughtersToPut(putParent, splitA, splitB);
            Put putA = MetaTableAccessor.makePutFromRegionInfo(splitA);
            Put putB = MetaTableAccessor.makePutFromRegionInfo(splitB);
            MetaTableAccessor.addLocation(putA, sn, 1L, splitA.getReplicaId());
            MetaTableAccessor.addLocation(putB, sn, 1L, splitB.getReplicaId());
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(putA, i);
                MetaTableAccessor.addEmptyLocation(putB, i);
            }
            byte[] tableRow = Bytes.toBytes((String)(parent.getRegionNameAsString() + 44));
            MetaTableAccessor.multiMutate(meta, tableRow, putParent, putA, putB);
        }
    }

    private static void multiMutate(Table table, byte[] row, Mutation ... mutations) throws IOException {
        CoprocessorRpcChannel channel = table.coprocessorService(row);
        MultiRowMutationProtos.MutateRowsRequest.Builder mmrBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
        for (Mutation mutation : mutations) {
            if (mutation instanceof Put) {
                mmrBuilder.addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, mutation));
                continue;
            }
            if (mutation instanceof Delete) {
                mmrBuilder.addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, mutation));
                continue;
            }
            throw new DoNotRetryIOException("multi in MetaEditor doesn't support " + mutation.getClass().getName());
        }
        MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
        try {
            service.mutateRows(null, mmrBuilder.build());
        }
        catch (ServiceException ex) {
            ProtobufUtil.toIOException(ex);
        }
    }

    public static void updateRegionLocation(Connection connection, HRegionInfo regionInfo, ServerName sn, long updateSeqNum) throws IOException {
        MetaTableAccessor.updateLocation(connection, regionInfo, sn, updateSeqNum);
    }

    private static void updateLocation(Connection connection, HRegionInfo regionInfo, ServerName sn, long openSeqNum) throws IOException {
        Put put = new Put(MetaTableAccessor.getMetaKeyForRegion(regionInfo));
        MetaTableAccessor.addLocation(put, sn, openSeqNum, regionInfo.getReplicaId());
        MetaTableAccessor.putToMetaTable(connection, put);
        LOG.info((Object)("Updated row " + regionInfo.getRegionNameAsString() + " with server=" + sn));
    }

    public static void deleteRegion(Connection connection, HRegionInfo regionInfo) throws IOException {
        Delete delete = new Delete(regionInfo.getRegionName());
        MetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info((Object)("Deleted " + regionInfo.getRegionNameAsString()));
    }

    public static void deleteRegions(Connection connection, List<HRegionInfo> regionsInfo) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>(regionsInfo.size());
        for (HRegionInfo hri : regionsInfo) {
            deletes.add(new Delete(hri.getRegionName()));
        }
        MetaTableAccessor.deleteFromMetaTable(connection, deletes);
        LOG.info((Object)("Deleted " + regionsInfo));
    }

    public static void mutateRegions(Connection connection, List<HRegionInfo> regionsToRemove, List<HRegionInfo> regionsToAdd) throws IOException {
        ArrayList<Mutation> mutation = new ArrayList<Mutation>();
        if (regionsToRemove != null) {
            for (HRegionInfo hri : regionsToRemove) {
                mutation.add(new Delete(hri.getRegionName()));
            }
        }
        if (regionsToAdd != null) {
            for (HRegionInfo hri : regionsToAdd) {
                mutation.add(MetaTableAccessor.makePutFromRegionInfo(hri));
            }
        }
        MetaTableAccessor.mutateMetaTable(connection, mutation);
        if (regionsToRemove != null && regionsToRemove.size() > 0) {
            LOG.debug((Object)("Deleted " + regionsToRemove));
        }
        if (regionsToAdd != null && regionsToAdd.size() > 0) {
            LOG.debug((Object)("Added " + regionsToAdd));
        }
    }

    public static void overwriteRegions(Connection connection, List<HRegionInfo> regionInfos, int regionReplication) throws IOException {
        MetaTableAccessor.deleteRegions(connection, regionInfos);
        Threads.sleep((long)20L);
        MetaTableAccessor.addRegionsToMeta(connection, regionInfos, regionReplication);
        LOG.info((Object)("Overwritten " + regionInfos));
    }

    public static void deleteMergeQualifiers(Connection connection, HRegionInfo mergedRegion) throws IOException {
        Delete delete = new Delete(mergedRegion.getRegionName());
        delete.deleteColumns(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER);
        delete.deleteColumns(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER);
        MetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info((Object)("Deleted references in merged region " + mergedRegion.getRegionNameAsString() + ", qualifier=" + Bytes.toStringBinary((byte[])HConstants.MERGEA_QUALIFIER) + " and qualifier=" + Bytes.toStringBinary((byte[])HConstants.MERGEB_QUALIFIER)));
    }

    private static Put addRegionInfo(Put p, HRegionInfo hri) throws IOException {
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, hri.toByteArray());
        return p;
    }

    public static Put addLocation(Put p, ServerName sn, long openSeqNum, int replicaId) {
        long now = EnvironmentEdgeManager.currentTime();
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn(replicaId), now, Bytes.toBytes((String)sn.getHostAndPort()));
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn(replicaId), now, Bytes.toBytes((long)sn.getStartcode()));
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn(replicaId), now, Bytes.toBytes((long)openSeqNum));
        return p;
    }

    public static Put addEmptyLocation(Put p, int replicaId) {
        long now = EnvironmentEdgeManager.currentTime();
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn(replicaId), now, null);
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn(replicaId), now, null);
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn(replicaId), now, null);
        return p;
    }

    static {
        int len = HRegionInfo.FIRST_META_REGIONINFO.getRegionName().length - 2;
        META_REGION_PREFIX = new byte[len];
        System.arraycopy(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), 0, META_REGION_PREFIX, 0, len);
        SERVER_COLUMN_PATTERN = Pattern.compile("^server(_[0-9a-fA-F]{4})?$");
    }

    static class CollectAllVisitor
    extends CollectingVisitor<Result> {
        CollectAllVisitor() {
        }

        @Override
        void add(Result r) {
            this.results.add(r);
        }
    }

    static abstract class CollectingVisitor<T>
    implements Visitor {
        final List<T> results = new ArrayList<T>();

        CollectingVisitor() {
        }

        @Override
        public boolean visit(Result r) throws IOException {
            if (r == null || r.isEmpty()) {
                return true;
            }
            this.add(r);
            return true;
        }

        abstract void add(Result var1);

        List<T> getResults() {
            return this.results;
        }
    }

    public static interface Visitor {
        public boolean visit(Result var1) throws IOException;
    }
}

