/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.network;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.apache.kafka.shaded.common.network.InvalidReceiveException;
import org.apache.kafka.shaded.common.network.Receive;

public class NetworkReceive
implements Receive {
    public static final String UNKNOWN_SOURCE = "";
    public static final int UNLIMITED = -1;
    private final String source;
    private final ByteBuffer size;
    private final int maxSize;
    private ByteBuffer buffer;

    public NetworkReceive(String source, ByteBuffer buffer) {
        this.source = source;
        this.buffer = buffer;
        this.size = null;
        this.maxSize = -1;
    }

    public NetworkReceive(String source) {
        this.source = source;
        this.size = ByteBuffer.allocate(4);
        this.buffer = null;
        this.maxSize = -1;
    }

    public NetworkReceive(int maxSize, String source) {
        this.source = source;
        this.size = ByteBuffer.allocate(4);
        this.buffer = null;
        this.maxSize = maxSize;
    }

    public NetworkReceive() {
        this(UNKNOWN_SOURCE);
    }

    @Override
    public String source() {
        return this.source;
    }

    @Override
    public boolean complete() {
        return !this.size.hasRemaining() && !this.buffer.hasRemaining();
    }

    @Override
    public long readFrom(ScatteringByteChannel channel) throws IOException {
        return this.readFromReadableChannel(channel);
    }

    @Deprecated
    public long readFromReadableChannel(ReadableByteChannel channel) throws IOException {
        int bytesRead;
        int read2 = 0;
        if (this.size.hasRemaining()) {
            bytesRead = channel.read(this.size);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            read2 += bytesRead;
            if (!this.size.hasRemaining()) {
                this.size.rewind();
                int receiveSize = this.size.getInt();
                if (receiveSize < 0) {
                    throw new InvalidReceiveException("Invalid receive (size = " + receiveSize + ")");
                }
                if (this.maxSize != -1 && receiveSize > this.maxSize) {
                    throw new InvalidReceiveException("Invalid receive (size = " + receiveSize + " larger than " + this.maxSize + ")");
                }
                this.buffer = ByteBuffer.allocate(receiveSize);
            }
        }
        if (this.buffer != null) {
            bytesRead = channel.read(this.buffer);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            read2 += bytesRead;
        }
        return read2;
    }

    public ByteBuffer payload() {
        return this.buffer;
    }
}

