/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.sling.testing.mock.jcr.MockItemDefinition;

class MockNodeDefinition
extends MockItemDefinition
implements NodeDefinition {
    protected String[] requiredPrimaryTypeNames;
    protected String defaultPrimaryTypeName;
    protected boolean allowSameNameSiblings;

    public MockNodeDefinition() {
        this(null, null);
    }

    public MockNodeDefinition(String declaringNodeTypeName, NodeTypeManager ntMgr) {
        super(declaringNodeTypeName, ntMgr);
    }

    public boolean allowsSameNameSiblings() {
        return this.allowSameNameSiblings;
    }

    public NodeType[] getRequiredPrimaryTypes() {
        ArrayList<NodeType> ntList = new ArrayList<NodeType>();
        for (String name : this.requiredPrimaryTypeNames) {
            try {
                ntList.add(this.ntMgr.getNodeType(name));
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Getting required primary types failed.", e);
            }
        }
        return ntList.toArray(new NodeType[ntList.size()]);
    }

    public String[] getRequiredPrimaryTypeNames() {
        return this.requiredPrimaryTypeNames;
    }

    public NodeType getDefaultPrimaryType() {
        NodeType nt = null;
        if (this.defaultPrimaryTypeName != null) {
            try {
                nt = this.ntMgr.getNodeType(this.defaultPrimaryTypeName);
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Getting default primary type failed.", e);
            }
        }
        return nt;
    }

    public String getDefaultPrimaryTypeName() {
        return this.defaultPrimaryTypeName;
    }
}

