/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl.operator;

import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.java.compiler.impl.ExpressionTranslator;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaSource;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.TypedNode;

public class StrictEqGenOp
implements BinaryOpGen {
    private final boolean negated;
    private static final String OBJECT_NAME = BinaryOperator.class.getName();
    private static final String METHOD_STRICT_EQ = "strictEq";

    public StrictEqGenOp(boolean negated) {
        this.negated = negated;
    }

    @Override
    public Type returnType(Type leftType, Type rightType) {
        return Type.BOOLEAN;
    }

    @Override
    public void generate(JavaSource source, ExpressionTranslator visitor, TypedNode left, TypedNode right) {
        if (this.negated) {
            source.negation();
        }
        source.startMethodCall(OBJECT_NAME, METHOD_STRICT_EQ);
        left.getNode().accept((NodeVisitor)visitor);
        source.separateArgument();
        right.getNode().accept((NodeVisitor)visitor);
        source.endCall();
    }
}

