/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jst;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.SlingRequestPaths;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.jcr.JsonItemWriter;
import org.apache.sling.scripting.jst.HtmlContentRenderer;
import org.cyberneko.html.parsers.DOMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

class HtmlCodeGenerator {
    private final List<String> libraryScripts = new LinkedList<String>();
    private final HtmlContentRenderer htmlRenderer;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String SLING_JS_PATH = "/system/sling.js";
    public static final String[] TITLE_PROPERTY_NAMES = new String[]{"title", "name", "description"};

    public HtmlCodeGenerator() {
        this.libraryScripts.add(SLING_JS_PATH);
        this.htmlRenderer = new HtmlContentRenderer();
    }

    void generateHtml(SlingHttpServletRequest request, String scriptPath, InputStream scriptStream, PrintWriter output) throws RepositoryException, JSONException, ScriptException, IOException {
        Resource r = request.getResource();
        Node n = (Node)r.adaptTo(Node.class);
        String pageTitle = this.getTitle(r, n);
        DOMParser parser = new DOMParser();
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
            parser.setProperty("http://cyberneko.org/html/properties/names/attrs", "lower");
            parser.parse(new InputSource(scriptStream));
        }
        catch (Exception e) {
            ScriptException se = new ScriptException("Error parsing script " + scriptPath);
            se.initCause(e);
            throw se;
        }
        Document template = parser.getDocument();
        StringWriter defaultRendering = new StringWriter();
        if (n != null) {
            PrintWriter pw = new PrintWriter(defaultRendering);
            this.htmlRenderer.render(pw, r, n, pageTitle);
            pw.flush();
        }
        StringWriter jsonData = new StringWriter();
        if (n != null) {
            PrintWriter pw = new PrintWriter(jsonData);
            JsonItemWriter j = new JsonItemWriter(null);
            boolean maxRecursionLevels = true;
            pw.print("var currentNode=");
            j.dump(n, (Writer)pw, 1);
            pw.print(";");
            pw.flush();
        }
        String xslt = "/xslt/script-transform.xsl";
        InputStream xslTransform = this.getClass().getResourceAsStream("/xslt/script-transform.xsl");
        if (xslTransform == null) {
            throw new ScriptException("XSLT transform /xslt/script-transform.xsl not found");
        }
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer(new StreamSource(xslTransform));
            t.setParameter("pageTitle", pageTitle);
            t.setParameter("slingScriptPath", HtmlCodeGenerator.fullPath(request, SLING_JS_PATH));
            t.setParameter("jstScriptPath", HtmlCodeGenerator.fullPath(request, scriptPath + ".jst.js"));
            t.setParameter("defaultRendering", defaultRendering.toString());
            t.setParameter("jsonData", jsonData.toString());
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(template);
            t.transform(source, result);
        }
        catch (Exception e) {
            ScriptException se = new ScriptException("Error in XSLT transform for " + scriptPath);
            se.initCause(e);
            throw se;
        }
        finally {
            xslTransform.close();
        }
    }

    static String fullPath(SlingHttpServletRequest request, String path) {
        return SlingRequestPaths.getContextPath((HttpServletRequest)request) + SlingRequestPaths.getServletPath((HttpServletRequest)request) + path;
    }

    protected String getTitle(Resource r, Node n) {
        String title = null;
        if (n != null) {
            for (String name : TITLE_PROPERTY_NAMES) {
                try {
                    String s;
                    if (!n.hasProperty(name) || (s = n.getProperty(name).getString()).length() <= 0) continue;
                    title = s;
                    break;
                }
                catch (RepositoryException re) {
                    this.log.warn("RepositoryException in getTitle()", (Throwable)re);
                }
            }
        }
        if (title == null && (title = r.getPath()).startsWith("/")) {
            title = title.substring(1);
        }
        return title;
    }
}

