/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jackrabbit.usermanager.impl.resource.AuthorizableValueMap;
import org.apache.sling.jackrabbit.usermanager.impl.resource.BaseResource;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;

@Adaptable(adaptableClass=Resource.class, adapters={@Adapter(value={Map.class, ValueMap.class, Authorizable.class}), @Adapter(condition="If the resource is an AuthorizableResource and represents a JCR User", value={User.class}), @Adapter(condition="If the resource is an AuthorizableResource and represents a JCR Group", value={Group.class})})
public class AuthorizableResource
extends BaseResource {
    protected final Authorizable authorizable;
    private final String resourceType;
    protected final SystemUserManagerPaths systemUserManagerPaths;

    public AuthorizableResource(Authorizable authorizable, ResourceResolver resourceResolver, String path, SystemUserManagerPaths systemUserManagerPaths) {
        super(resourceResolver, path);
        this.authorizable = authorizable;
        this.systemUserManagerPaths = systemUserManagerPaths;
        this.resourceType = this.toResourceType(authorizable);
    }

    protected String toResourceType(Authorizable authorizable) {
        if (authorizable.isGroup()) {
            return "sling/group";
        }
        return "sling/user";
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public <T> T adaptTo(Class<T> type) {
        if (type == Map.class || type == ValueMap.class) {
            AuthorizableValueMap valueMap = new AuthorizableValueMap(this.authorizable, this.systemUserManagerPaths);
            return type.cast(valueMap);
        }
        if (type == Authorizable.class || type == User.class && !this.authorizable.isGroup() || type == Group.class && this.authorizable.isGroup()) {
            return type.cast(this.authorizable);
        }
        return (T)super.adaptTo(type);
    }

    public String toString() {
        String id = null;
        if (this.authorizable != null) {
            try {
                id = this.authorizable.getID();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + ", id=" + id + ", path=" + this.getPath();
    }
}

