/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core.processing.zopfli;

import com.googlecode.pngtastic.core.processing.zopfli.Hash;
import com.googlecode.pngtastic.core.processing.zopfli.LongestMatchCache;
import com.googlecode.pngtastic.core.processing.zopfli.LzStore;
import com.googlecode.pngtastic.core.processing.zopfli.SymbolStats;

final class Cookie {
    static final int SPLIT_PARTITIONS = 9;
    static final int[] intZeroes = new int[65536];
    static final char[] charZeroes = new char[65536];
    static final byte[] byteZeroes = new byte[65536];
    static final int[] intMOnes = new int[65536];
    static final char[] charOnes = new char[65536];
    static final long[] costMax = new long[65536];
    private static final int POOL_MAX = 10240;
    final Node[] list0 = new Node[15];
    final Node[] list1 = new Node[15];
    final Node[] leaves1 = new Node[288];
    final Node[] leaves2 = new Node[288];
    final int[] i320a = new int[320];
    final int[] i320b = new int[320];
    final int[] i320c = new int[320];
    final int[] i288a = new int[288];
    final int[] i288b = new int[288];
    final int[] i288c = new int[288];
    final int[] i289a = new int[289];
    final char[] c259a = new char[259];
    final int[] i32a = new int[32];
    final int[] i32b = new int[32];
    final int[] i32c = new int[32];
    final int[] i19a = new int[19];
    final int[] i19b = new int[19];
    final int[] i19c = new int[19];
    final int[] i16a = new int[16];
    final int[] i16b = new int[16];
    final int[] p = new int[9];
    final int[] vp = new int[9];
    final char[] lengthArray;
    final long[] costs;
    final char[] path;
    final int[] splitPoints;
    final int[] splitSize;
    final SymbolStats stats = new SymbolStats();
    final SymbolStats bestStats = new SymbolStats();
    final SymbolStats lastStats = new SymbolStats();
    final Hash h = new Hash();
    final LzStore store1;
    final LzStore store2;
    final LongestMatchCache lmc;
    final int masterBlockSize;
    final int blockSplittingMax = 15;
    private final Node[] nodes = new Node[10240];
    int lenVal;
    int distVal;
    int rnd = 42;
    private int nextNode;

    Cookie(int masterBlockSize) {
        this.masterBlockSize = masterBlockSize;
        for (int i = 0; i < 10240; ++i) {
            this.nodes[i] = new Node();
        }
        this.splitPoints = new int[16];
        this.splitSize = new int[16];
        this.lengthArray = new char[masterBlockSize + 1];
        this.costs = new long[masterBlockSize + 1];
        this.path = new char[masterBlockSize + 1];
        this.lmc = new LongestMatchCache(masterBlockSize);
        this.store1 = new LzStore(masterBlockSize);
        this.store2 = new LzStore(masterBlockSize);
    }

    static void expand(Object array) {
        for (int i = 64; i < 65536; i += i) {
            System.arraycopy(array, 0, array, i, i);
        }
    }

    static void fill0(int[] array, int length) {
        int i = 0;
        while (i < length) {
            int j = i + 65536;
            if (j > length) {
                j = length;
            }
            System.arraycopy(intZeroes, 0, array, i, j - i);
            i = j;
        }
    }

    static void fill0(char[] array, int length) {
        int i = 0;
        while (i < length) {
            int j = i + 65536;
            if (j > length) {
                j = length;
            }
            System.arraycopy(charZeroes, 0, array, i, j - i);
            i = j;
        }
    }

    static void fillCostMax(long[] array, int length) {
        int i = 0;
        while (i < length) {
            int j = i + 65536;
            if (j > length) {
                j = length;
            }
            System.arraycopy(costMax, 0, array, i, j - i);
            i = j;
        }
    }

    final Node node(int weight, int count, Node tail) {
        Node result = this.nodes[this.nextNode++];
        result.weight = weight;
        result.count = count;
        result.tail = tail;
        return result;
    }

    final void resetPool() {
        this.nextNode = 0;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            Cookie.intMOnes[i] = -1;
            Cookie.charOnes[i] = '\u0001';
            Cookie.costMax[i] = Long.MAX_VALUE;
        }
        Cookie.expand(intMOnes);
        Cookie.expand(charOnes);
        Cookie.expand(costMax);
    }

    static class Node {
        int weight;
        Node tail;
        int count;

        Node() {
        }
    }
}

