/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

public class PngPixel {
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;
    private final int x;
    private final int y;
    private int freq = 0;
    private boolean duplicate;

    public PngPixel(int x, int y, int red, int green, int blue, boolean is8bit) {
        this(x, y, red, green, blue, is8bit ? 255 : 65535);
    }

    public PngPixel(int x, int y, int red, int green, int blue, int alpha) {
        this.x = x;
        this.y = y;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public double rgbaDistance(PngPixel other, int bits) {
        if (bits == 8) {
            return this.rgba8Distance(other);
        }
        return this.rgba16Distance(other);
    }

    public double rgba8Distance(PngPixel other) {
        int rdiff = this.red - other.red;
        int gdiff = this.green - other.green;
        int bdiff = this.blue - other.blue;
        long result = rdiff * rdiff + gdiff * gdiff + bdiff * bdiff;
        return (double)result / 195075.0;
    }

    public double rgba16Distance(PngPixel other) {
        int rdiff = this.red - other.red;
        int gdiff = this.green - other.green;
        int bdiff = this.blue - other.blue;
        long result = rdiff * rdiff + gdiff * gdiff + bdiff * bdiff;
        return (double)result / 1.2884508675E10;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alpha;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PngPixel other = (PngPixel)obj;
        return this.alpha == other.alpha && this.blue == other.blue && this.green == other.green && this.red == other.red;
    }

    public String toString() {
        return String.format("%02X%02X%02X.%02X@%d,%d:%d", this.red, this.green, this.blue, this.alpha, this.x, this.y, this.freq);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getFreq() {
        return this.freq;
    }

    public void setFreq(int freq) {
        this.freq = freq;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }
}

