/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.standalone;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.discovery.PropertyProvider;

public class ProviderInfo
implements Comparable<ProviderInfo> {
    public final PropertyProvider provider;
    public final int ranking;
    public final long serviceId;
    public final Map<String, String> properties = new HashMap<String, String>();

    public ProviderInfo(PropertyProvider provider, Map<String, Object> serviceProps) {
        this.provider = provider;
        Object sr = serviceProps.get("service.ranking");
        this.ranking = sr == null || !(sr instanceof Integer) ? 0 : (Integer)sr;
        this.serviceId = (Long)serviceProps.get("service.id");
        Object namesObj = serviceProps.get("instance.properties");
        if (namesObj instanceof String) {
            String val = provider.getProperty((String)namesObj);
            if (val != null) {
                this.properties.put((String)namesObj, val);
            }
        } else if (namesObj instanceof String[]) {
            for (String name : (String[])namesObj) {
                String val = provider.getProperty(name);
                if (val == null) continue;
                this.properties.put(name, val);
            }
        }
    }

    @Override
    public int compareTo(ProviderInfo o) {
        if (this.ranking < o.ranking) {
            return -1;
        }
        if (this.ranking > o.ranking) {
            return 1;
        }
        return this.serviceId < o.serviceId ? 1 : -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProviderInfo) {
            return ((ProviderInfo)obj).serviceId == this.serviceId;
        }
        return false;
    }

    public int hashCode() {
        return this.provider.hashCode();
    }
}

