/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualInstanceHelper {
    private static final Logger logger = LoggerFactory.getLogger(VirtualInstanceHelper.class);

    public static void dumpRepo(ResourceResolverFactory resourceResolverFactory) throws Exception {
        Session session = (Session)resourceResolverFactory.getServiceResourceResolver(null).adaptTo(Session.class);
        logger.info("dumpRepo: ====== START =====");
        logger.info("dumpRepo: repo = " + session.getRepository());
        VirtualInstanceHelper.dump(session.getRootNode());
        logger.info("dumpRepo: ======  END  =====");
        session.logout();
    }

    public static void dump(Node node) throws RepositoryException {
        if (node.getPath().equals("/jcr:system") || node.getPath().equals("/rep:policy")) {
            return;
        }
        PropertyIterator pi = node.getProperties();
        StringBuilder sb = new StringBuilder();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            sb.append(" ");
            sb.append(p.getName());
            sb.append("=");
            if (p.getType() == 6) {
                sb.append(p.getBoolean());
                continue;
            }
            if (p.getType() == 1) {
                sb.append(p.getString());
                continue;
            }
            if (p.getType() == 5) {
                sb.append(p.getDate().getTime());
                continue;
            }
            sb.append("<unknown type=" + p.getType() + "/>");
        }
        StringBuffer depth = new StringBuffer();
        for (int i = 0; i < node.getDepth(); ++i) {
            depth.append(" ");
        }
        logger.info(depth + "/" + node.getName() + " -- " + sb);
        NodeIterator it = node.getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            VirtualInstanceHelper.dump(child);
        }
    }
}

