/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.maven.jspc.JspCServletContext;
import org.apache.sling.maven.jspc.TrackingClassLoader;
import org.apache.sling.scripting.jsp.jasper.compiler.PageInfo;
import org.codehaus.plexus.util.StringUtils;

public class DependencyTracker {
    private final Log logger;
    private final Path projectDirectory;
    private final Path sourceDirectory;
    private final JspCServletContext jspCServletContext;
    private final TrackingClassLoader classLoader;
    private final List<Artifact> compileScopeArtifacts;
    private final Map<String, Set<String>> packageProviders;
    private final Set<String> unusedDependencies;
    private final Map<String, Set<String>> jspDependencies;
    private final Map<String, PageInfo> jspInfo;
    private final Path relativeSourceDirectory;

    public DependencyTracker(Log logger, Path projectDirectory, Path sourceDirectory, JspCServletContext jspCServletContext, TrackingClassLoader classLoader, List<Artifact> compileScopeArtifacts) {
        this.logger = logger;
        this.projectDirectory = projectDirectory;
        this.sourceDirectory = sourceDirectory;
        this.jspCServletContext = jspCServletContext;
        this.classLoader = classLoader;
        this.compileScopeArtifacts = compileScopeArtifacts;
        this.packageProviders = new ConcurrentHashMap<String, Set<String>>();
        this.unusedDependencies = Collections.synchronizedSet(new HashSet());
        this.jspDependencies = new ConcurrentHashMap<String, Set<String>>();
        this.jspInfo = new ConcurrentHashMap<String, PageInfo>();
        this.relativeSourceDirectory = projectDirectory.relativize(sourceDirectory);
    }

    public void processCompileDependencies() {
        this.compileScopeArtifacts.forEach(artifact -> {
            this.unusedDependencies.add(artifact.getId());
            try (JarFile jar = new JarFile(artifact.getFile());){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String path;
                    JarEntry e = entries.nextElement();
                    if (e.isDirectory() || !(path = e.getName()).endsWith(".class")) continue;
                    if ((path = StringUtils.chomp((String)path, (String)"/")).charAt(0) == '/') {
                        path = path.substring(1);
                    }
                    String packageName = path.replace("/", ".");
                    Set artifacts = this.packageProviders.computeIfAbsent(packageName, k -> new HashSet());
                    artifacts.add(artifact.getId());
                }
            }
            catch (IOException e) {
                this.logger.error((CharSequence)("Error while accessing jar file " + artifact.getFile().getAbsolutePath()), (Throwable)e);
            }
        });
        ArrayList<String> packages = new ArrayList<String>(this.classLoader.getPackageNames());
        Collections.sort(packages);
        for (String packageName : packages) {
            Set<String> artifacts = this.packageProviders.get(packageName);
            if (artifacts == null || artifacts.isEmpty()) continue;
            artifacts.forEach(this.unusedDependencies::remove);
        }
        this.jspInfo.forEach((jsp, pageInfo) -> {
            List dependencies = pageInfo.getDependants();
            if (!dependencies.isEmpty()) {
                Set dependenciesSet = this.jspDependencies.computeIfAbsent(Paths.get(this.relativeSourceDirectory.toString(), jsp).toString(), key -> new HashSet());
                for (Object d : dependencies) {
                    String dependency = (String)d;
                    try {
                        URL dependencyURL = this.jspCServletContext.getResource(dependency);
                        if (dependencyURL != null) {
                            Path dependencyPath = Paths.get(dependencyURL.getPath(), new String[0]);
                            if (dependencyPath.startsWith(this.sourceDirectory)) {
                                dependenciesSet.add(this.projectDirectory.relativize(dependencyPath).toString());
                                continue;
                            }
                            dependenciesSet.add(dependencyURL.toExternalForm());
                            continue;
                        }
                        if (dependency.startsWith("/")) {
                            dependency = dependency.substring(1);
                        }
                        JarURLConnection jarURLConnection = (JarURLConnection)this.classLoader.findResource(dependency).openConnection();
                        for (Artifact a : this.compileScopeArtifacts) {
                            if (!a.getFile().getAbsolutePath().equals(jarURLConnection.getJarFile().getName())) continue;
                            this.unusedDependencies.remove(a.getId());
                        }
                        dependenciesSet.add(Paths.get(jarURLConnection.getJarFileURL().getPath(), new String[0]).getFileName() + ":/" + dependency);
                    }
                    catch (IOException e) {
                        dependenciesSet.add(dependency);
                    }
                }
            }
        });
    }

    public void collectJSPInfo(String jspFile, PageInfo pageInfo) {
        this.jspInfo.put(jspFile, pageInfo);
    }

    public Map<String, Set<String>> getPackageProviders() {
        return Collections.unmodifiableMap(this.packageProviders);
    }

    public Set<String> getUnusedDependencies() {
        return Collections.unmodifiableSet(this.unusedDependencies);
    }

    public Map<String, Set<String>> getJspDependencies() {
        return Collections.unmodifiableMap(this.jspDependencies);
    }
}

