/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.wkt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.base.URIDataStoreProvider;
import org.apache.sis.storage.wkt.FirstKeywordPeek;
import org.apache.sis.storage.wkt.Store;
import org.apache.sis.util.Version;

@StoreMetadata(formatName="WKT", fileSuffixes={"prj"}, capabilities={Capability.READ})
public final class StoreProvider
extends URIDataStoreProvider {
    public static final String NAME = "WKT";
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.wkt");

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        return Peek.INSTANCE.probeContent(this, connector);
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new Store(this, connector);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    static final class Peek
    extends FirstKeywordPeek {
        static final Peek INSTANCE = new Peek();
        static final int MIN_LENGTH = 6;
        private final Set<String> keywords;

        private Peek() {
            super(14);
            HashSet<String> s = new HashSet<String>(22);
            s.add("GeodeticCRS");
            s.add("GeodCRS");
            s.add("GeogCS");
            s.add("GeocCS");
            s.add("VerticalCRS");
            s.add("VertCRS");
            s.add("Vert_CS");
            s.add("TimeCRS");
            s.add("ImageCRS");
            s.add("EngineeringCRS");
            s.add("EngCRS");
            s.add("Local_CS");
            s.add("CompoundCRS");
            s.add("Compd_CS");
            s.add("ProjectedCRS");
            s.add("ProjCRS");
            s.add("ProjCS");
            s.add("Fitted_CS");
            s.add("BoundCRS");
            this.keywords = s;
        }

        final Set<String> keywords() {
            return Collections.unmodifiableSet(this.keywords);
        }

        @Override
        protected boolean isPostKeyword(int c) {
            return c == 91 || c == 40;
        }

        @Override
        protected ProbeResult forKeyword(char[] keyword, int length) {
            if (length >= 6) {
                int pos = length;
                int version = 1;
                keyword[0] = (char)(keyword[0] & 0xFFDF);
                int n = --pos;
                keyword[n] = (char)(keyword[n] & 0xFFDF);
                int n2 = --pos;
                keyword[n2] = (char)(keyword[n2] & 0xFFDF);
                if (keyword[n2] == 'R') {
                    int n3 = --pos;
                    keyword[n3] = (char)(keyword[n3] & 0xFFDF);
                    version = 2;
                }
                while (--pos != 0) {
                    if (keyword[pos] == '_') continue;
                    int n4 = pos;
                    keyword[n4] = (char)(keyword[n4] | 0x20);
                }
                if (this.keywords.contains(String.valueOf(keyword, 0, length))) {
                    return new ProbeResult(true, null, Version.valueOf((int[])new int[]{version}));
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
    }
}

