/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.plugin.sofa.param;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.lang.NonNull;

/**
 * The interface Generic param service.
 * This service is used to construct the parameters required for the sofa generalization.
 */
public interface SofaParamResolveService {

    /**
     * Build parameter pair.
     * this is Resolve http body to get dubbo param.
     *
     * @param body           the body
     * @param parameterTypes the parameter types
     * @return the pair
     */
    @NonNull
    Pair<String[], Object[]> buildParameter(String body, String parameterTypes);
}
