/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.springframework.cloud.netflix.ribbon.support.ContextAwareRequest;
import org.springframework.cloud.netflix.ribbon.support.RibbonRequestCustomizer;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;

public class OkHttpRibbonRequest
extends ContextAwareRequest
implements Cloneable {
    public OkHttpRibbonRequest(RibbonCommandContext context) {
        super(context);
    }

    public Request toRequest() {
        Headers.Builder headers = new Headers.Builder();
        for (Object name : this.context.getHeaders().keySet()) {
            List values = (List)this.context.getHeaders().get(name);
            for (String value : values) {
                headers.add((String)name, value);
            }
        }
        HttpUrl.Builder url = HttpUrl.get((URI)this.uri).newBuilder();
        for (String name : this.context.getParams().keySet()) {
            List values = (List)this.context.getParams().get((Object)name);
            for (String value : values) {
                url.addQueryParameter(name, value);
            }
        }
        InputStreamRequestBody requestBody = null;
        if (this.context.getRequestEntity() != null && HttpMethod.permitsRequestBody((String)this.context.getMethod())) {
            MediaType mediaType = null;
            if (headers.get("Content-Type") != null) {
                mediaType = MediaType.parse((String)headers.get("Content-Type"));
            }
            requestBody = new InputStreamRequestBody(this.context.getRequestEntity(), mediaType, this.context.getContentLength());
        }
        Request.Builder builder = new Request.Builder().url(url.build()).headers(headers.build()).method(this.context.getMethod(), requestBody);
        RibbonRequestCustomizer.Runner.customize(this.context.getRequestCustomizers(), builder);
        return builder.build();
    }

    public OkHttpRibbonRequest withNewUri(URI uri) {
        return new OkHttpRibbonRequest(this.newContext(uri));
    }

    static class InputStreamRequestBody
    extends RequestBody {
        private InputStream inputStream;
        private MediaType mediaType;
        private Long contentLength;

        InputStreamRequestBody(InputStream inputStream, MediaType mediaType, Long contentLength) {
            this.inputStream = inputStream;
            this.mediaType = mediaType;
            this.contentLength = contentLength;
        }

        public MediaType contentType() {
            return this.mediaType;
        }

        public long contentLength() {
            if (this.contentLength != null) {
                return this.contentLength;
            }
            try {
                return this.inputStream.available();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        public void writeTo(BufferedSink sink) throws IOException {
            try (Source source = null;){
                source = Okio.source((InputStream)this.inputStream);
                sink.writeAll(source);
            }
        }
    }
}

