/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class UadpDataSetReaderMessageDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15655;
  }

  // Properties.
  protected final long groupVersion;
  protected final int networkMessageNumber;
  protected final int dataSetOffset;
  protected final GuidValue dataSetClassId;
  protected final UadpNetworkMessageContentMask networkMessageContentMask;
  protected final UadpDataSetMessageContentMask dataSetMessageContentMask;
  protected final double publishingInterval;
  protected final double receiveOffset;
  protected final double processingOffset;

  public UadpDataSetReaderMessageDataType(
      long groupVersion,
      int networkMessageNumber,
      int dataSetOffset,
      GuidValue dataSetClassId,
      UadpNetworkMessageContentMask networkMessageContentMask,
      UadpDataSetMessageContentMask dataSetMessageContentMask,
      double publishingInterval,
      double receiveOffset,
      double processingOffset) {
    super();
    this.groupVersion = groupVersion;
    this.networkMessageNumber = networkMessageNumber;
    this.dataSetOffset = dataSetOffset;
    this.dataSetClassId = dataSetClassId;
    this.networkMessageContentMask = networkMessageContentMask;
    this.dataSetMessageContentMask = dataSetMessageContentMask;
    this.publishingInterval = publishingInterval;
    this.receiveOffset = receiveOffset;
    this.processingOffset = processingOffset;
  }

  public long getGroupVersion() {
    return groupVersion;
  }

  public int getNetworkMessageNumber() {
    return networkMessageNumber;
  }

  public int getDataSetOffset() {
    return dataSetOffset;
  }

  public GuidValue getDataSetClassId() {
    return dataSetClassId;
  }

  public UadpNetworkMessageContentMask getNetworkMessageContentMask() {
    return networkMessageContentMask;
  }

  public UadpDataSetMessageContentMask getDataSetMessageContentMask() {
    return dataSetMessageContentMask;
  }

  public double getPublishingInterval() {
    return publishingInterval;
  }

  public double getReceiveOffset() {
    return receiveOffset;
  }

  public double getProcessingOffset() {
    return processingOffset;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("UadpDataSetReaderMessageDataType");

    // Simple Field (groupVersion)
    writeSimpleField("groupVersion", groupVersion, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (networkMessageNumber)
    writeSimpleField(
        "networkMessageNumber", networkMessageNumber, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (dataSetOffset)
    writeSimpleField("dataSetOffset", dataSetOffset, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (dataSetClassId)
    writeSimpleField("dataSetClassId", dataSetClassId, writeComplex(writeBuffer));

    // Simple Field (networkMessageContentMask)
    writeSimpleEnumField(
        "networkMessageContentMask",
        "UadpNetworkMessageContentMask",
        networkMessageContentMask,
        writeEnum(
            UadpNetworkMessageContentMask::getValue,
            UadpNetworkMessageContentMask::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (dataSetMessageContentMask)
    writeSimpleEnumField(
        "dataSetMessageContentMask",
        "UadpDataSetMessageContentMask",
        dataSetMessageContentMask,
        writeEnum(
            UadpDataSetMessageContentMask::getValue,
            UadpDataSetMessageContentMask::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (publishingInterval)
    writeSimpleField("publishingInterval", publishingInterval, writeDouble(writeBuffer, 64));

    // Simple Field (receiveOffset)
    writeSimpleField("receiveOffset", receiveOffset, writeDouble(writeBuffer, 64));

    // Simple Field (processingOffset)
    writeSimpleField("processingOffset", processingOffset, writeDouble(writeBuffer, 64));

    writeBuffer.popContext("UadpDataSetReaderMessageDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    UadpDataSetReaderMessageDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (groupVersion)
    lengthInBits += 32;

    // Simple field (networkMessageNumber)
    lengthInBits += 16;

    // Simple field (dataSetOffset)
    lengthInBits += 16;

    // Simple field (dataSetClassId)
    lengthInBits += dataSetClassId.getLengthInBits();

    // Simple field (networkMessageContentMask)
    lengthInBits += 32;

    // Simple field (dataSetMessageContentMask)
    lengthInBits += 32;

    // Simple field (publishingInterval)
    lengthInBits += 64;

    // Simple field (receiveOffset)
    lengthInBits += 64;

    // Simple field (processingOffset)
    lengthInBits += 64;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("UadpDataSetReaderMessageDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long groupVersion = readSimpleField("groupVersion", readUnsignedLong(readBuffer, 32));

    int networkMessageNumber =
        readSimpleField("networkMessageNumber", readUnsignedInt(readBuffer, 16));

    int dataSetOffset = readSimpleField("dataSetOffset", readUnsignedInt(readBuffer, 16));

    GuidValue dataSetClassId =
        readSimpleField(
            "dataSetClassId", readComplex(() -> GuidValue.staticParse(readBuffer), readBuffer));

    UadpNetworkMessageContentMask networkMessageContentMask =
        readEnumField(
            "networkMessageContentMask",
            "UadpNetworkMessageContentMask",
            readEnum(
                UadpNetworkMessageContentMask::enumForValue, readUnsignedLong(readBuffer, 32)));

    UadpDataSetMessageContentMask dataSetMessageContentMask =
        readEnumField(
            "dataSetMessageContentMask",
            "UadpDataSetMessageContentMask",
            readEnum(
                UadpDataSetMessageContentMask::enumForValue, readUnsignedLong(readBuffer, 32)));

    double publishingInterval = readSimpleField("publishingInterval", readDouble(readBuffer, 64));

    double receiveOffset = readSimpleField("receiveOffset", readDouble(readBuffer, 64));

    double processingOffset = readSimpleField("processingOffset", readDouble(readBuffer, 64));

    readBuffer.closeContext("UadpDataSetReaderMessageDataType");
    // Create the instance
    return new UadpDataSetReaderMessageDataTypeBuilderImpl(
        groupVersion,
        networkMessageNumber,
        dataSetOffset,
        dataSetClassId,
        networkMessageContentMask,
        dataSetMessageContentMask,
        publishingInterval,
        receiveOffset,
        processingOffset);
  }

  public static class UadpDataSetReaderMessageDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long groupVersion;
    private final int networkMessageNumber;
    private final int dataSetOffset;
    private final GuidValue dataSetClassId;
    private final UadpNetworkMessageContentMask networkMessageContentMask;
    private final UadpDataSetMessageContentMask dataSetMessageContentMask;
    private final double publishingInterval;
    private final double receiveOffset;
    private final double processingOffset;

    public UadpDataSetReaderMessageDataTypeBuilderImpl(
        long groupVersion,
        int networkMessageNumber,
        int dataSetOffset,
        GuidValue dataSetClassId,
        UadpNetworkMessageContentMask networkMessageContentMask,
        UadpDataSetMessageContentMask dataSetMessageContentMask,
        double publishingInterval,
        double receiveOffset,
        double processingOffset) {
      this.groupVersion = groupVersion;
      this.networkMessageNumber = networkMessageNumber;
      this.dataSetOffset = dataSetOffset;
      this.dataSetClassId = dataSetClassId;
      this.networkMessageContentMask = networkMessageContentMask;
      this.dataSetMessageContentMask = dataSetMessageContentMask;
      this.publishingInterval = publishingInterval;
      this.receiveOffset = receiveOffset;
      this.processingOffset = processingOffset;
    }

    public UadpDataSetReaderMessageDataType build() {
      UadpDataSetReaderMessageDataType uadpDataSetReaderMessageDataType =
          new UadpDataSetReaderMessageDataType(
              groupVersion,
              networkMessageNumber,
              dataSetOffset,
              dataSetClassId,
              networkMessageContentMask,
              dataSetMessageContentMask,
              publishingInterval,
              receiveOffset,
              processingOffset);
      return uadpDataSetReaderMessageDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof UadpDataSetReaderMessageDataType)) {
      return false;
    }
    UadpDataSetReaderMessageDataType that = (UadpDataSetReaderMessageDataType) o;
    return (getGroupVersion() == that.getGroupVersion())
        && (getNetworkMessageNumber() == that.getNetworkMessageNumber())
        && (getDataSetOffset() == that.getDataSetOffset())
        && (getDataSetClassId() == that.getDataSetClassId())
        && (getNetworkMessageContentMask() == that.getNetworkMessageContentMask())
        && (getDataSetMessageContentMask() == that.getDataSetMessageContentMask())
        && (getPublishingInterval() == that.getPublishingInterval())
        && (getReceiveOffset() == that.getReceiveOffset())
        && (getProcessingOffset() == that.getProcessingOffset())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getGroupVersion(),
        getNetworkMessageNumber(),
        getDataSetOffset(),
        getDataSetClassId(),
        getNetworkMessageContentMask(),
        getDataSetMessageContentMask(),
        getPublishingInterval(),
        getReceiveOffset(),
        getProcessingOffset());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
