/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class MessagePDU implements Message {

  // Abstract accessors for discriminator values.
  public abstract String getMessageType();

  public abstract Boolean getResponse();

  // Properties.
  protected final ChunkType chunk;

  public MessagePDU(ChunkType chunk) {
    super();
    this.chunk = chunk;
  }

  public ChunkType getChunk() {
    return chunk;
  }

  protected abstract void serializeMessagePDUChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("MessagePDU");

    // Discriminator Field (messageType) (Used as input to a switch field)
    writeDiscriminatorField("messageType", getMessageType(), writeString(writeBuffer, 24));

    // Simple Field (chunk)
    writeSimpleEnumField(
        "chunk",
        "ChunkType",
        chunk,
        writeEnum(ChunkType::getValue, ChunkType::name, writeString(writeBuffer, 8)));

    // Implicit Field (totalLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    long totalLength = (long) (getLengthInBytes());
    writeImplicitField("totalLength", totalLength, writeUnsignedLong(writeBuffer, 32));

    // Switch field (Serialize the sub-type)
    serializeMessagePDUChild(writeBuffer);

    writeBuffer.popContext("MessagePDU");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    MessagePDU _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Discriminator Field (messageType)
    lengthInBits += 24;

    // Simple field (chunk)
    lengthInBits += 8;

    // Implicit Field (totalLength)
    lengthInBits += 32;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static MessagePDU staticParse(ReadBuffer readBuffer, Boolean response, Boolean binary)
      throws ParseException {
    readBuffer.pullContext("MessagePDU");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    String messageType = readDiscriminatorField("messageType", readString(readBuffer, 24));

    ChunkType chunk =
        readEnumField(
            "chunk", "ChunkType", readEnum(ChunkType::enumForValue, readString(readBuffer, 8)));

    long totalLength = readImplicitField("totalLength", readUnsignedLong(readBuffer, 32));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    MessagePDUBuilder builder = null;
    if (EvaluationHelper.equals(messageType, (String) "HEL")
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = OpcuaHelloRequest.staticParseMessagePDUBuilder(readBuffer, response, binary);
    } else if (EvaluationHelper.equals(messageType, (String) "ACK")
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = OpcuaAcknowledgeResponse.staticParseMessagePDUBuilder(readBuffer, response, binary);
    } else if (EvaluationHelper.equals(messageType, (String) "OPN")
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder =
          OpcuaOpenRequest.staticParseMessagePDUBuilder(readBuffer, totalLength, response, binary);
    } else if (EvaluationHelper.equals(messageType, (String) "OPN")
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder =
          OpcuaOpenResponse.staticParseMessagePDUBuilder(readBuffer, totalLength, response, binary);
    } else if (EvaluationHelper.equals(messageType, (String) "CLO")
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder = OpcuaCloseRequest.staticParseMessagePDUBuilder(readBuffer, response, binary);
    } else if (EvaluationHelper.equals(messageType, (String) "MSG")
        && EvaluationHelper.equals(response, (boolean) false)) {
      builder =
          OpcuaMessageRequest.staticParseMessagePDUBuilder(
              readBuffer, totalLength, response, binary);
    } else if (EvaluationHelper.equals(messageType, (String) "MSG")
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder =
          OpcuaMessageResponse.staticParseMessagePDUBuilder(
              readBuffer, totalLength, response, binary);
    } else if (EvaluationHelper.equals(messageType, (String) "ERR")
        && EvaluationHelper.equals(response, (boolean) true)) {
      builder = OpcuaMessageError.staticParseMessagePDUBuilder(readBuffer, response, binary);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "messageType="
              + messageType
              + " "
              + "response="
              + response
              + "]");
    }

    readBuffer.closeContext("MessagePDU");
    // Create the instance
    MessagePDU _messagePDU = builder.build(chunk);
    return _messagePDU;
  }

  public interface MessagePDUBuilder {
    MessagePDU build(ChunkType chunk);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MessagePDU)) {
      return false;
    }
    MessagePDU that = (MessagePDU) o;
    return (getChunk() == that.getChunk()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getChunk());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
