/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetBinaryLightingPV {
  OFF((short) 0),
  ON((short) 1),
  WARN((short) 2),
  WARN_OFF((short) 3),
  WARN_RELINQUISH((short) 4),
  STOP((short) 5),
  VENDOR_PROPRIETARY_VALUE((short) 0XFF);
  private static final Map<Short, BACnetBinaryLightingPV> map;

  static {
    map = new HashMap<>();
    for (BACnetBinaryLightingPV value : BACnetBinaryLightingPV.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  BACnetBinaryLightingPV(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static BACnetBinaryLightingPV enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
