/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableSessions is an enum
type OpcuaNodeIdServicesVariableSessions int32

type IOpcuaNodeIdServicesVariableSessions interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionDiagnosticsArray                                                      OpcuaNodeIdServicesVariableSessions = 2027
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray                                              OpcuaNodeIdServicesVariableSessions = 2028
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics                                    OpcuaNodeIdServicesVariableSessions = 12098
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId                          OpcuaNodeIdServicesVariableSessions = 12099
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName                        OpcuaNodeIdServicesVariableSessions = 12100
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription                  OpcuaNodeIdServicesVariableSessions = 12101
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri                          OpcuaNodeIdServicesVariableSessions = 12102
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl                        OpcuaNodeIdServicesVariableSessions = 12103
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds                          OpcuaNodeIdServicesVariableSessions = 12104
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout               OpcuaNodeIdServicesVariableSessions = 12105
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize             OpcuaNodeIdServicesVariableSessions = 12106
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime               OpcuaNodeIdServicesVariableSessions = 12107
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime              OpcuaNodeIdServicesVariableSessions = 12108
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount          OpcuaNodeIdServicesVariableSessions = 12109
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount         OpcuaNodeIdServicesVariableSessions = 12110
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue      OpcuaNodeIdServicesVariableSessions = 12111
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount                  OpcuaNodeIdServicesVariableSessions = 12112
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount           OpcuaNodeIdServicesVariableSessions = 12113
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount                          OpcuaNodeIdServicesVariableSessions = 12114
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount                   OpcuaNodeIdServicesVariableSessions = 12115
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount                         OpcuaNodeIdServicesVariableSessions = 12116
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount                 OpcuaNodeIdServicesVariableSessions = 12117
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount                          OpcuaNodeIdServicesVariableSessions = 12118
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount          OpcuaNodeIdServicesVariableSessions = 12119
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount          OpcuaNodeIdServicesVariableSessions = 12120
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount             OpcuaNodeIdServicesVariableSessions = 12121
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount                 OpcuaNodeIdServicesVariableSessions = 12122
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount          OpcuaNodeIdServicesVariableSessions = 12123
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount            OpcuaNodeIdServicesVariableSessions = 12124
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount            OpcuaNodeIdServicesVariableSessions = 12125
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount             OpcuaNodeIdServicesVariableSessions = 12126
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount                       OpcuaNodeIdServicesVariableSessions = 12127
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount                     OpcuaNodeIdServicesVariableSessions = 12128
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount         OpcuaNodeIdServicesVariableSessions = 12129
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount           OpcuaNodeIdServicesVariableSessions = 12130
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount                      OpcuaNodeIdServicesVariableSessions = 12131
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount                 OpcuaNodeIdServicesVariableSessions = 12132
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount                   OpcuaNodeIdServicesVariableSessions = 12133
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount              OpcuaNodeIdServicesVariableSessions = 12134
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount                        OpcuaNodeIdServicesVariableSessions = 12135
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount                    OpcuaNodeIdServicesVariableSessions = 12136
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount OpcuaNodeIdServicesVariableSessions = 12137
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount                    OpcuaNodeIdServicesVariableSessions = 12138
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount                     OpcuaNodeIdServicesVariableSessions = 12139
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount                 OpcuaNodeIdServicesVariableSessions = 12140
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount               OpcuaNodeIdServicesVariableSessions = 12141
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics                            OpcuaNodeIdServicesVariableSessions = 12142
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId                  OpcuaNodeIdServicesVariableSessions = 12143
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession      OpcuaNodeIdServicesVariableSessions = 12144
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory        OpcuaNodeIdServicesVariableSessions = 12145
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism    OpcuaNodeIdServicesVariableSessions = 12146
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding                   OpcuaNodeIdServicesVariableSessions = 12147
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol          OpcuaNodeIdServicesVariableSessions = 12148
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode               OpcuaNodeIdServicesVariableSessions = 12149
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri          OpcuaNodeIdServicesVariableSessions = 12150
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate          OpcuaNodeIdServicesVariableSessions = 12151
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray                          OpcuaNodeIdServicesVariableSessions = 12152
	OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_CurrentRoleIds                                        OpcuaNodeIdServicesVariableSessions = 19302
)

var OpcuaNodeIdServicesVariableSessionsValues []OpcuaNodeIdServicesVariableSessions

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableSessionsValues = []OpcuaNodeIdServicesVariableSessions{
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionDiagnosticsArray,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray,
		OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_CurrentRoleIds,
	}
}

func OpcuaNodeIdServicesVariableSessionsByValue(value int32) (enum OpcuaNodeIdServicesVariableSessions, ok bool) {
	switch value {
	case 12098:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics, true
	case 12099:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId, true
	case 12100:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName, true
	case 12101:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription, true
	case 12102:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri, true
	case 12103:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl, true
	case 12104:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds, true
	case 12105:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout, true
	case 12106:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize, true
	case 12107:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime, true
	case 12108:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime, true
	case 12109:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount, true
	case 12110:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount, true
	case 12111:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue, true
	case 12112:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount, true
	case 12113:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount, true
	case 12114:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount, true
	case 12115:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount, true
	case 12116:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount, true
	case 12117:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount, true
	case 12118:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount, true
	case 12119:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount, true
	case 12120:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount, true
	case 12121:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount, true
	case 12122:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount, true
	case 12123:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount, true
	case 12124:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount, true
	case 12125:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount, true
	case 12126:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount, true
	case 12127:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount, true
	case 12128:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount, true
	case 12129:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount, true
	case 12130:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount, true
	case 12131:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount, true
	case 12132:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount, true
	case 12133:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount, true
	case 12134:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount, true
	case 12135:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount, true
	case 12136:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount, true
	case 12137:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount, true
	case 12138:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount, true
	case 12139:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount, true
	case 12140:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount, true
	case 12141:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount, true
	case 12142:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics, true
	case 12143:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId, true
	case 12144:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession, true
	case 12145:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory, true
	case 12146:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism, true
	case 12147:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding, true
	case 12148:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol, true
	case 12149:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode, true
	case 12150:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri, true
	case 12151:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate, true
	case 12152:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray, true
	case 19302:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_CurrentRoleIds, true
	case 2027:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionDiagnosticsArray, true
	case 2028:
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSessionsByName(value string) (enum OpcuaNodeIdServicesVariableSessions, ok bool) {
	switch value {
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder_CurrentRoleIds":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_CurrentRoleIds, true
	case "SessionsDiagnosticsSummaryType_SessionDiagnosticsArray":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionDiagnosticsArray, true
	case "SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray":
		return OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSessionsKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableSessionsValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableSessions(structType any) OpcuaNodeIdServicesVariableSessions {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableSessions {
		if sOpcuaNodeIdServicesVariableSessions, ok := typ.(OpcuaNodeIdServicesVariableSessions); ok {
			return sOpcuaNodeIdServicesVariableSessions
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableSessions) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableSessions) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableSessionsParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableSessions, error) {
	return OpcuaNodeIdServicesVariableSessionsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableSessionsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableSessions, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableSessions", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableSessions")
	}
	if enum, ok := OpcuaNodeIdServicesVariableSessionsByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableSessions")
		return OpcuaNodeIdServicesVariableSessions(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableSessions) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableSessions) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableSessions", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableSessions) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableSessions) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionId"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SessionName"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientDescription"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ServerUri"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_EndpointUrl"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_LocaleIds"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ActualSessionTimeout"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_MaxResponseMessageSize"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientConnectionTime"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ClientLastContactTime"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CurrentPublishRequestsInQueue"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TotalRequestCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnauthorizedRequestCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ReadCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryReadCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_WriteCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_HistoryUpdateCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CallCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifyMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetMonitoringModeCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetTriggeringCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteMonitoredItemsCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_CreateSubscriptionCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_ModifySubscriptionCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_SetPublishingModeCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_PublishCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RepublishCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TransferSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteSubscriptionsCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddNodesCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_AddReferencesCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteNodesCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_DeleteReferencesCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_BrowseNextCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_TranslateBrowsePathsToNodeIdsCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryFirstCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_QueryNextCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_RegisterNodesCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionDiagnostics_UnregisterNodesCount"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SessionId"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdOfSession"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientUserIdHistory"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_AuthenticationMechanism"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_Encoding"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_TransportProtocol"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityMode"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SessionSecurityDiagnostics_ClientCertificate"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_SubscriptionDiagnosticsArray"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_ClientName_Placeholder_CurrentRoleIds:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder_CurrentRoleIds"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionDiagnosticsArray:
		return "SessionsDiagnosticsSummaryType_SessionDiagnosticsArray"
	case OpcuaNodeIdServicesVariableSessions_SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray:
		return "SessionsDiagnosticsSummaryType_SessionSecurityDiagnosticsArray"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableSessions) String() string {
	return e.PLC4XEnumName()
}
