/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableConfiguration is an enum
type OpcuaNodeIdServicesVariableConfiguration int32

type IOpcuaNodeIdServicesVariableConfiguration interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_LastUpdateTime                      OpcuaNodeIdServicesVariableConfiguration = 15438
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CurrentVersion                      OpcuaNodeIdServicesVariableConfiguration = 15439
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ActivityTimeout                     OpcuaNodeIdServicesVariableConfiguration = 15503
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_SupportedDataType                   OpcuaNodeIdServicesVariableConfiguration = 15504
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_InputArguments       OpcuaNodeIdServicesVariableConfiguration = 15506
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_OutputArguments      OpcuaNodeIdServicesVariableConfiguration = 15507
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ConfirmUpdate_InputArguments        OpcuaNodeIdServicesVariableConfiguration = 15511
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_InputArguments  OpcuaNodeIdServicesVariableConfiguration = 15514
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_OutputArguments OpcuaNodeIdServicesVariableConfiguration = 15515
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileConfirmUpdateMethodType_InputArguments   OpcuaNodeIdServicesVariableConfiguration = 15536
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdateType_EnumValues                        OpcuaNodeIdServicesVariableConfiguration = 15540
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_OldVersion             OpcuaNodeIdServicesVariableConfiguration = 15542
	OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_NewVersion             OpcuaNodeIdServicesVariableConfiguration = 15543
)

var OpcuaNodeIdServicesVariableConfigurationValues []OpcuaNodeIdServicesVariableConfiguration

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableConfigurationValues = []OpcuaNodeIdServicesVariableConfiguration{
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_LastUpdateTime,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CurrentVersion,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ActivityTimeout,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_SupportedDataType,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ConfirmUpdate_InputArguments,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_InputArguments,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_OutputArguments,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileConfirmUpdateMethodType_InputArguments,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdateType_EnumValues,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_OldVersion,
		OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_NewVersion,
	}
}

func OpcuaNodeIdServicesVariableConfigurationByValue(value int32) (enum OpcuaNodeIdServicesVariableConfiguration, ok bool) {
	switch value {
	case 15438:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_LastUpdateTime, true
	case 15439:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CurrentVersion, true
	case 15503:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ActivityTimeout, true
	case 15504:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_SupportedDataType, true
	case 15506:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_InputArguments, true
	case 15507:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_OutputArguments, true
	case 15511:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ConfirmUpdate_InputArguments, true
	case 15514:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_InputArguments, true
	case 15515:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_OutputArguments, true
	case 15536:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileConfirmUpdateMethodType_InputArguments, true
	case 15540:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdateType_EnumValues, true
	case 15542:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_OldVersion, true
	case 15543:
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_NewVersion, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableConfigurationByName(value string) (enum OpcuaNodeIdServicesVariableConfiguration, ok bool) {
	switch value {
	case "ConfigurationFileType_LastUpdateTime":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_LastUpdateTime, true
	case "ConfigurationFileType_CurrentVersion":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CurrentVersion, true
	case "ConfigurationFileType_ActivityTimeout":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ActivityTimeout, true
	case "ConfigurationFileType_SupportedDataType":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_SupportedDataType, true
	case "ConfigurationFileType_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_InputArguments, true
	case "ConfigurationFileType_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_OutputArguments, true
	case "ConfigurationFileType_ConfirmUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ConfirmUpdate_InputArguments, true
	case "ConfigurationFileCloseAndUpdateMethodType_InputArguments":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_InputArguments, true
	case "ConfigurationFileCloseAndUpdateMethodType_OutputArguments":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_OutputArguments, true
	case "ConfigurationFileConfirmUpdateMethodType_InputArguments":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileConfirmUpdateMethodType_InputArguments, true
	case "ConfigurationUpdateType_EnumValues":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdateType_EnumValues, true
	case "ConfigurationUpdatedAuditEventType_OldVersion":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_OldVersion, true
	case "ConfigurationUpdatedAuditEventType_NewVersion":
		return OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_NewVersion, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableConfigurationKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableConfigurationValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableConfiguration(structType any) OpcuaNodeIdServicesVariableConfiguration {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableConfiguration {
		if sOpcuaNodeIdServicesVariableConfiguration, ok := typ.(OpcuaNodeIdServicesVariableConfiguration); ok {
			return sOpcuaNodeIdServicesVariableConfiguration
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableConfiguration) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableConfiguration) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableConfigurationParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableConfiguration, error) {
	return OpcuaNodeIdServicesVariableConfigurationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableConfigurationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableConfiguration, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableConfiguration", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableConfiguration")
	}
	if enum, ok := OpcuaNodeIdServicesVariableConfigurationByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableConfiguration")
		return OpcuaNodeIdServicesVariableConfiguration(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableConfiguration) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableConfiguration) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableConfiguration", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableConfiguration) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableConfiguration) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_LastUpdateTime:
		return "ConfigurationFileType_LastUpdateTime"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CurrentVersion:
		return "ConfigurationFileType_CurrentVersion"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ActivityTimeout:
		return "ConfigurationFileType_ActivityTimeout"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_SupportedDataType:
		return "ConfigurationFileType_SupportedDataType"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_InputArguments:
		return "ConfigurationFileType_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_CloseAndUpdate_OutputArguments:
		return "ConfigurationFileType_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileType_ConfirmUpdate_InputArguments:
		return "ConfigurationFileType_ConfirmUpdate_InputArguments"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_InputArguments:
		return "ConfigurationFileCloseAndUpdateMethodType_InputArguments"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileCloseAndUpdateMethodType_OutputArguments:
		return "ConfigurationFileCloseAndUpdateMethodType_OutputArguments"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationFileConfirmUpdateMethodType_InputArguments:
		return "ConfigurationFileConfirmUpdateMethodType_InputArguments"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdateType_EnumValues:
		return "ConfigurationUpdateType_EnumValues"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_OldVersion:
		return "ConfigurationUpdatedAuditEventType_OldVersion"
	case OpcuaNodeIdServicesVariableConfiguration_ConfigurationUpdatedAuditEventType_NewVersion:
		return "ConfigurationUpdatedAuditEventType_NewVersion"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableConfiguration) String() string {
	return e.PLC4XEnumName()
}
