/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLoggingType is the corresponding interface of BACnetConstructedDataLoggingType
type BACnetConstructedDataLoggingType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLoggingType returns LoggingType (property field)
	GetLoggingType() BACnetLoggingTypeTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetLoggingTypeTagged
	// IsBACnetConstructedDataLoggingType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLoggingType()
	// CreateBuilder creates a BACnetConstructedDataLoggingTypeBuilder
	CreateBACnetConstructedDataLoggingTypeBuilder() BACnetConstructedDataLoggingTypeBuilder
}

// _BACnetConstructedDataLoggingType is the data-structure of this message
type _BACnetConstructedDataLoggingType struct {
	BACnetConstructedDataContract
	LoggingType BACnetLoggingTypeTagged
}

var _ BACnetConstructedDataLoggingType = (*_BACnetConstructedDataLoggingType)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLoggingType)(nil)

// NewBACnetConstructedDataLoggingType factory function for _BACnetConstructedDataLoggingType
func NewBACnetConstructedDataLoggingType(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, loggingType BACnetLoggingTypeTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLoggingType {
	if loggingType == nil {
		panic("loggingType of type BACnetLoggingTypeTagged for BACnetConstructedDataLoggingType must not be nil")
	}
	_result := &_BACnetConstructedDataLoggingType{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LoggingType:                   loggingType,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLoggingTypeBuilder is a builder for BACnetConstructedDataLoggingType
type BACnetConstructedDataLoggingTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(loggingType BACnetLoggingTypeTagged) BACnetConstructedDataLoggingTypeBuilder
	// WithLoggingType adds LoggingType (property field)
	WithLoggingType(BACnetLoggingTypeTagged) BACnetConstructedDataLoggingTypeBuilder
	// WithLoggingTypeBuilder adds LoggingType (property field) which is build by the builder
	WithLoggingTypeBuilder(func(BACnetLoggingTypeTaggedBuilder) BACnetLoggingTypeTaggedBuilder) BACnetConstructedDataLoggingTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLoggingType or returns an error if something is wrong
	Build() (BACnetConstructedDataLoggingType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLoggingType
}

// NewBACnetConstructedDataLoggingTypeBuilder() creates a BACnetConstructedDataLoggingTypeBuilder
func NewBACnetConstructedDataLoggingTypeBuilder() BACnetConstructedDataLoggingTypeBuilder {
	return &_BACnetConstructedDataLoggingTypeBuilder{_BACnetConstructedDataLoggingType: new(_BACnetConstructedDataLoggingType)}
}

type _BACnetConstructedDataLoggingTypeBuilder struct {
	*_BACnetConstructedDataLoggingType

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataLoggingTypeBuilder) = (*_BACnetConstructedDataLoggingTypeBuilder)(nil)

func (b *_BACnetConstructedDataLoggingTypeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLoggingType
}

func (b *_BACnetConstructedDataLoggingTypeBuilder) WithMandatoryFields(loggingType BACnetLoggingTypeTagged) BACnetConstructedDataLoggingTypeBuilder {
	return b.WithLoggingType(loggingType)
}

func (b *_BACnetConstructedDataLoggingTypeBuilder) WithLoggingType(loggingType BACnetLoggingTypeTagged) BACnetConstructedDataLoggingTypeBuilder {
	b.LoggingType = loggingType
	return b
}

func (b *_BACnetConstructedDataLoggingTypeBuilder) WithLoggingTypeBuilder(builderSupplier func(BACnetLoggingTypeTaggedBuilder) BACnetLoggingTypeTaggedBuilder) BACnetConstructedDataLoggingTypeBuilder {
	builder := builderSupplier(b.LoggingType.CreateBACnetLoggingTypeTaggedBuilder())
	var err error
	b.LoggingType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetLoggingTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLoggingTypeBuilder) Build() (BACnetConstructedDataLoggingType, error) {
	if b.LoggingType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'loggingType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataLoggingType.deepCopy(), nil
}

func (b *_BACnetConstructedDataLoggingTypeBuilder) MustBuild() BACnetConstructedDataLoggingType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLoggingTypeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLoggingTypeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLoggingTypeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLoggingTypeBuilder().(*_BACnetConstructedDataLoggingTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataLoggingTypeBuilder creates a BACnetConstructedDataLoggingTypeBuilder
func (b *_BACnetConstructedDataLoggingType) CreateBACnetConstructedDataLoggingTypeBuilder() BACnetConstructedDataLoggingTypeBuilder {
	if b == nil {
		return NewBACnetConstructedDataLoggingTypeBuilder()
	}
	return &_BACnetConstructedDataLoggingTypeBuilder{_BACnetConstructedDataLoggingType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLoggingType) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLoggingType) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LOGGING_TYPE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLoggingType) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLoggingType) GetLoggingType() BACnetLoggingTypeTagged {
	return m.LoggingType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLoggingType) GetActualValue() BACnetLoggingTypeTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetLoggingTypeTagged(m.GetLoggingType())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLoggingType(structType any) BACnetConstructedDataLoggingType {
	if casted, ok := structType.(BACnetConstructedDataLoggingType); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLoggingType); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLoggingType) GetTypeName() string {
	return "BACnetConstructedDataLoggingType"
}

func (m *_BACnetConstructedDataLoggingType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (loggingType)
	lengthInBits += m.LoggingType.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLoggingType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLoggingType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLoggingType BACnetConstructedDataLoggingType, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLoggingType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLoggingType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	loggingType, err := ReadSimpleField[BACnetLoggingTypeTagged](ctx, "loggingType", ReadComplex[BACnetLoggingTypeTagged](BACnetLoggingTypeTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'loggingType' field"))
	}
	m.LoggingType = loggingType

	actualValue, err := ReadVirtualField[BACnetLoggingTypeTagged](ctx, "actualValue", (*BACnetLoggingTypeTagged)(nil), loggingType)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLoggingType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLoggingType")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLoggingType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLoggingType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLoggingType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLoggingType")
		}

		if err := WriteSimpleField[BACnetLoggingTypeTagged](ctx, "loggingType", m.GetLoggingType(), WriteComplex[BACnetLoggingTypeTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'loggingType' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLoggingType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLoggingType")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLoggingType) IsBACnetConstructedDataLoggingType() {}

func (m *_BACnetConstructedDataLoggingType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLoggingType) deepCopy() *_BACnetConstructedDataLoggingType {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLoggingTypeCopy := &_BACnetConstructedDataLoggingType{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetLoggingTypeTagged](m.LoggingType),
	}
	_BACnetConstructedDataLoggingTypeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLoggingTypeCopy
}

func (m *_BACnetConstructedDataLoggingType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
