<!---
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License. See accompanying LICENSE file.

  Original imported from Apache Aurora.
-->

Committer's Guide
=================

Information for official Apache Parquet committers.

Setting up your email account
-----------------------------
Once your Apache ID has been set up you can configure your account and add ssh keys and setup an
email forwarding address at

    http://id.apache.org

Additional instructions for setting up your new committer email can be found at

    http://www.apache.org/dev/user-email.html

The recommended setup is to configure all services (mailing lists, JIRA) to send
emails to your @apache.org email address.


Creating a gpg key for releases
-------------------------------
In order to create a release candidate you will need a gpg key published to an external key server
and that key will need to be added to our KEYS file as well.

1. Create a key:

               gpg --gen-key

2. Add your gpg key to the Apache Parquet {format,mr,cpp} KEYS file:

               git clone git@github.com:apache/parquet-cpp.git
               (gpg --list-sigs <KEY ID> && gpg --armor --export <KEY ID>) >> KEYS
               git add KEYS && git commit -m "Adding gpg key for <APACHE ID>"
               ./rbt post -o -g

3. Publish the key to an external key server:

               gpg --keyserver pgp.mit.edu --send-keys <KEY ID>

4. Update the changes to the KEYS file to the Apache Parquet svn dist locations listed below:

               https://dist.apache.org/repos/dist/dev/parquet/KEYS
               https://dist.apache.org/repos/dist/release/parquet/KEYS

5. Add your key to git config for use with the release scripts:

               git config --global user.signingkey <KEY ID>


Creating a release
------------------
The following will guide you through the steps to create a release candidate, vote, and finally an
official Apache Parquet C++ release. Before starting your gpg key should be in the KEYS file and you
must have access to commit to the dist.a.o repositories.

1. Ensure that all issues resolved for this release candidate are tagged with the correct Fix
Version in JIRA, the changelog script will use this to generate the CHANGELOG in step #2.
To assign the fix version:

    * Look up the [previous release date](https://issues.apache.org/jira/browse/parquet/?selectedTab=com.atlassian.jira.jira-projects-plugin:versions-panel).
    * Query all issues resolved after that release date: `project = PARQUET AND status in (resolved, Closed) and fixVersion is empty and resolutiondate >= "YYYY/MM/DD"`
    * In the upper right corner of the query result, select Tools > Bulk Edit.
    * Select all issues > edit issue > set 'Change Fix Version/s' to the release version.
    * Make sure to uncheck 'Send mail for this update' at the bottom.

2. Prepare RELEASE-NOTES.md for the release. This just boils down to removing the "(Not yet
released)" suffix from the impending release.

2. Create a release candidate. This will automatically update the CHANGELOG and commit it, create a
branch and update the current version within the trunk. To create a minor version update and publish
it run

               ./dev/release/release-candidate -l m -p

3. Update, if necessary, the draft email created from the `release-candidate` script in step #2 and
send the [VOTE] email to the dev@ mailing list. You can verify the release signature and checksums
by running

               ./dev/release/verify-release-candidate

4. Wait for the vote to complete. If the vote fails close the vote by replying to the initial [VOTE]
email sent in step #3 by editing the subject to [RESULT][VOTE] ... and noting the failure reason
(example [here](http://markmail.org/message/d4d6xtvj7vgwi76f)). You'll also need to manually revert
the commits generated by the release candidate script that incremented the snapshot version and
updated the changelog. Once that is done, now address any issues and go back to step #1 and run
again, this time you will use the -r flag to increment the release candidate version. This will
automatically clean up the release candidate rc0 branch and source distribution.

               ./dev/release/release-candidate -l m -r 1 -p

5. Once the vote has successfully passed create the release

**IMPORTANT: make sure to use the correct release at this final step (e.g.: `-r 1` if rc1 candidate
has been voted for). Once the release tag is pushed it will be very hard to undo due to remote
git pre-receive hook explicitly forbidding release tag manipulations.**

               ./dev/release/release

6. Update the draft email created fom the `release` script in step #5 to include the Apache ID's for
all binding votes and send the [RESULT][VOTE] email to the dev@ mailing list.

