/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.job;

import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.UnexpectedTypeException;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bval.jsr.ConstraintCached;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.ValidatorUtils;
import org.apache.bval.util.reflection.Reflection;
import org.apache.bval.util.reflection.TypeUtils;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
class ComputeConstraintValidatorClass<A extends Annotation>
implements Supplier<Class<? extends ConstraintValidator<A, ?>>> {
    private static final String CV = ConstraintValidator.class.getSimpleName();
    private final ConstraintCached constraintsCache;
    private final ConstraintD<?> descriptor;
    private final ValidationTarget validationTarget;
    private final Class<?> validatedType;

    ComputeConstraintValidatorClass(ConstraintCached constraintsCache, ConstraintD<A> descriptor, ValidationTarget validationTarget, Class<?> validatedType) {
        this.constraintsCache = Validate.notNull(constraintsCache, "constraintsCache", new Object[0]);
        this.descriptor = Validate.notNull(descriptor, "descriptor", new Object[0]);
        this.validationTarget = Validate.notNull(validationTarget, "validationTarget", new Object[0]);
        this.validatedType = Validate.notNull(validatedType, "validatedType", new Object[0]);
    }

    @Override
    public Class<? extends ConstraintValidator<A, ?>> get() {
        Class<? extends Annotation> constraintType = this.descriptor.getAnnotation().annotationType();
        return this.findValidator(this.constraintsCache.getConstraintValidatorInfo(constraintType));
    }

    private Class<? extends ConstraintValidator<A, ?>> findValidator(Set<ConstraintCached.ConstraintValidatorInfo<A>> infos) {
        switch (this.validationTarget) {
            case PARAMETERS: {
                return this.findCrossParameterValidator(infos);
            }
            case ANNOTATED_ELEMENT: {
                return this.findAnnotatedElementValidator(infos);
            }
        }
        return null;
    }

    private Class<? extends ConstraintValidator<A, ?>> findCrossParameterValidator(Set<ConstraintCached.ConstraintValidatorInfo<A>> infos) {
        Set set = infos.stream().filter(info -> info.getSupportedTargets().contains((Object)ValidationTarget.PARAMETERS)).collect(Collectors.toSet());
        Class<? extends Annotation> constraintType = this.descriptor.getAnnotation().annotationType();
        int size = set.size();
        Exceptions.raiseIf(size > 1 || !this.isComposed() && set.isEmpty(), ConstraintDefinitionException::new, "%d cross-parameter %ss found for constraint type %s", size, CV, constraintType);
        Class result = ((ConstraintCached.ConstraintValidatorInfo)set.iterator().next()).getType();
        if (!TypeUtils.isAssignable(Object[].class, ValidatorUtils.getValidatedType(result))) {
            Exceptions.raise(ConstraintDefinitionException::new, "Cross-parameter %s %s does not support the validation of an object array", CV, result.getName());
        }
        return result;
    }

    private Class<? extends ConstraintValidator<A, ?>> findAnnotatedElementValidator(Set<ConstraintCached.ConstraintValidatorInfo<A>> infos) {
        String cond;
        Map validators = infos.stream().filter(info -> info.getSupportedTargets().contains((Object)ValidationTarget.ANNOTATED_ELEMENT)).map(ConstraintCached.ConstraintValidatorInfo::getType).collect(Collectors.toMap(ValidatorUtils::getValidatedType, Function.identity(), (v1, v2) -> {
            Exceptions.raiseUnless(Objects.equals(v1, v2), UnexpectedTypeException::new, "Detected collision of constraint and target type between %s and %s", v1, v2);
            return v1;
        }));
        HashMap candidates = new HashMap();
        this.walkHierarchy().filter(validators::containsKey).forEach(type -> {
            if (!candidates.keySet().stream().anyMatch(k -> TypeUtils.isAssignable(k, (Type)type))) {
                candidates.put(type, (Class)validators.get(type));
            }
        });
        switch (candidates.size()) {
            case 1: {
                Class result = (Class)candidates.values().iterator().next();
                return result;
            }
            case 0: {
                if (this.isComposed()) {
                    return null;
                }
                cond = "No compliant";
                break;
            }
            default: {
                cond = "> 1 maximally specific";
            }
        }
        throw Exceptions.create(UnexpectedTypeException::new, "%s %s %s found for annotated element of type %s", cond, this.descriptor.getAnnotation().annotationType().getName(), CV, TypeUtils.toString(this.validatedType));
    }

    private Stream<Class<?>> walkHierarchy() {
        TypeWrapper w = new TypeWrapper(Reflection.primitiveToWrapper(this.validatedType));
        Stream.Builder hierarchy = Stream.builder();
        Reflection.hierarchy(w.componentType, Reflection.Interfaces.INCLUDE).forEach(hierarchy);
        Stream<Class<?>> result = hierarchy.build().map(w::unwrapArrayComponentType);
        if (this.validatedType.isInterface() || this.validatedType.isArray()) {
            return Stream.concat(result, Stream.of(Object.class));
        }
        return result;
    }

    private boolean isComposed() {
        return !this.descriptor.getComposingConstraints().isEmpty();
    }

    private static class TypeWrapper {
        final Class<?> componentType;
        final int arrayDepth;

        TypeWrapper(Class<?> type) {
            Class<?> c = type;
            int d = 0;
            while (Object[].class.isAssignableFrom(c)) {
                ++d;
                c = c.getComponentType();
            }
            this.componentType = c;
            this.arrayDepth = d;
        }

        Class<?> unwrapArrayComponentType(Class<?> t) {
            Exceptions.raiseUnless(t.isAssignableFrom(this.componentType), IllegalArgumentException::new, "%s not assignable from %s", t, this.componentType);
            if (this.arrayDepth == 0) {
                return t;
            }
            return Array.newInstance(t, new int[this.arrayDepth]).getClass();
        }
    }
}

