/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.faces.annotation.PortletNamingContainer;
import org.apache.myfaces.portlet.faces.context.PortletExternalContextImpl;
import org.apache.myfaces.portlet.faces.el.PortletELContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletFacesContextImpl
extends FacesContext {
    private Application mApplication;
    private RenderKitFactory mRenderKitFactory;
    private ExternalContext mExternalContext;
    private ResponseStream mResponseStream = null;
    private ResponseWriter mResponseWriter = null;
    private UIViewRoot mViewRoot;
    private boolean mRenderResponse = false;
    private boolean mResponseComplete = false;
    private FacesMessage.Severity mMaximumSeverity = FacesMessage.SEVERITY_INFO;
    private ELContext mElContext = null;
    private LinkedHashMap<String, List<FacesMessage>> mMessages = new LinkedHashMap();

    public PortletFacesContextImpl(ExternalContext externalContext, Lifecycle lifecycle) throws FacesException {
        this.mApplication = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        this.mRenderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.mExternalContext = externalContext;
        FacesContext.setCurrentInstance((FacesContext)this);
    }

    public ELContext getELContext() {
        if (this.mElContext == null) {
            ELContextListener[] listeners;
            Application app = this.getApplication();
            this.mElContext = new PortletELContextImpl(app.getELResolver());
            this.mElContext.putContext(FacesContext.class, (Object)FacesContext.getCurrentInstance());
            UIViewRoot root = this.getViewRoot();
            if (null != root) {
                this.mElContext.setLocale(root.getLocale());
            }
            if ((listeners = app.getELContextListeners()).length > 0) {
                ELContextEvent event = new ELContextEvent(this.mElContext);
                for (ELContextListener listener : listeners) {
                    listener.contextCreated(event);
                }
            }
        }
        return this.mElContext;
    }

    public ExternalContext getExternalContext() {
        return this.mExternalContext;
    }

    public FacesMessage.Severity getMaximumSeverity() {
        return this.mMaximumSeverity;
    }

    public Iterator<FacesMessage> getMessages() {
        ArrayList<FacesMessage> results = new ArrayList<FacesMessage>();
        for (List<FacesMessage> messages : this.mMessages.values()) {
            results.addAll(messages);
        }
        return results.iterator();
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public Iterator<String> getClientIdsWithMessages() {
        return this.mMessages.keySet().iterator();
    }

    public Iterator<FacesMessage> getMessages(String clientId) {
        List<Object> list = this.mMessages.get(clientId);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list.iterator();
    }

    public RenderKit getRenderKit() {
        if (this.getViewRoot() == null) {
            return null;
        }
        String renderKitId = this.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        return this.mRenderKitFactory.getRenderKit((FacesContext)this, renderKitId);
    }

    public boolean getRenderResponse() {
        return this.mRenderResponse;
    }

    public boolean getResponseComplete() {
        return this.mResponseComplete;
    }

    public void setResponseStream(ResponseStream responseStream) {
        if (responseStream == null) {
            throw new NullPointerException("setResponseStream(null)");
        }
        this.mResponseStream = responseStream;
    }

    public ResponseStream getResponseStream() {
        return this.mResponseStream;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        if (responseWriter == null) {
            throw new NullPointerException("setResponseWriter(null)");
        }
        this.mResponseWriter = responseWriter;
    }

    public ResponseWriter getResponseWriter() {
        return this.mResponseWriter;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        if (viewRoot == null) {
            throw new NullPointerException("setViewRoot(null)");
        }
        this.mViewRoot = viewRoot;
        if (this.mViewRoot.getClass().getAnnotation(PortletNamingContainer.class) != null) {
            try {
                PortletResponse pr = (PortletResponse)this.mExternalContext.getResponse();
                pr.addProperty("X-JAVAX-PORTLET-FACES-NAMESPACED-RESPONSE", "true");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public UIViewRoot getViewRoot() {
        return this.mViewRoot;
    }

    public void addMessage(String clientId, FacesMessage message) {
        if (message == null) {
            throw new NullPointerException();
        }
        List<FacesMessage> list = this.mMessages.get(clientId);
        if (list == null) {
            list = new ArrayList<FacesMessage>(2);
            this.mMessages.put(clientId, list);
        }
        list.add(message);
        FacesMessage.Severity severity = message.getSeverity();
        if (severity != null && severity.compareTo((Object)this.mMaximumSeverity) > 0) {
            this.mMaximumSeverity = severity;
        }
    }

    public void release() {
        PortletRequest request = (PortletRequest)this.mExternalContext.getRequest();
        List preExistingAttrs = (List)request.getAttribute("org.apache.myfaces.portlet.faces.preExistingAttributeNames");
        ArrayList<String> removeList = new ArrayList<String>(preExistingAttrs.size());
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (preExistingAttrs.contains(name)) continue;
            removeList.add(name);
        }
        Iterator iter = removeList.iterator();
        while (iter.hasNext()) {
            request.removeAttribute((String)iter.next());
        }
        if (this.mExternalContext != null && this.mExternalContext instanceof PortletExternalContextImpl) {
            ((PortletExternalContextImpl)this.mExternalContext).release();
            this.mExternalContext = null;
        }
        this.mApplication = null;
        this.mResponseStream = null;
        this.mResponseWriter = null;
        this.mViewRoot = null;
        this.mElContext = null;
        FacesContext.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.mRenderResponse = true;
    }

    public void responseComplete() {
        this.mResponseComplete = true;
    }
}

