<?xml version="1.0" encoding="UTF-8"?>
<!--
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
        
    <parent>
        <groupId>org.apache.myfaces.core</groupId>
        <artifactId>myfaces-core-project</artifactId>
        <version>2.0.24</version>
        <relativePath>../parent/pom.xml</relativePath>
    </parent>

    <modelVersion>4.0.0</modelVersion>
    
    <groupId>org.apache.myfaces.core.internal</groupId>
    <artifactId>myfaces-impl-ee6</artifactId>
    <packaging>jar</packaging>
    <name>Apache MyFaces JSF-2.0 Core Impl for Java EE 6</name>
    <description>
        The private implementation classes of the Apache MyFaces Core JSF-2.0 Implementation which require Java EE 6
    </description>
    <url>http://myfaces.apache.org/core20/myfaces-implee6</url>
        
    <scm>
        <connection>scm:svn:http://svn.apache.org/repos/asf/myfaces/core/tags/myfaces-core-module-2.0.24/implee6</connection>
        <developerConnection>scm:svn:https://svn.apache.org/repos/asf/myfaces/core/tags/myfaces-core-module-2.0.24/implee6</developerConnection>
        <url>http://svn.apache.org/repos/asf/myfaces/core/tags/myfaces-core-module-2.0.24/implee6</url>
    </scm>

    <build>

        <plugins>

            <!-- license checker needs to exclude some kinds of files -->
            <plugin>
                <groupId>org.apache.rat</groupId>
                <artifactId>apache-rat-plugin</artifactId>
                <configuration>
                    <excludes>
                        <!-- services files are trivial config files with no comments -->
                        <exclude>src/main/resources/META-INF/services/javax.servlet.ServletContainerInitializer</exclude>
                    </excludes>
                </configuration>
            </plugin>

        </plugins>

    </build>

    <dependencies>

        <!-- myfaces-api -->
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-api</artifactId>
        </dependency>

        <!-- we can use myfaces-shared-impl, but we cannot use myfaces-impl (cyclic dependency) -->
        <dependency>
            <groupId>org.apache.myfaces.core.internal</groupId>
            <artifactId>myfaces-impl-shared</artifactId>
        </dependency>

        <!-- in this module we need Servlet 3.0 (instead of 2.5) -->
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-servlet_3.0_spec</artifactId>
        </dependency>
      
    </dependencies>
  
</project>
