/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.io.IOException;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.internal.metadata.sql.LocalDataSource;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.Shutdown;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;

public abstract class Initializer {
    public static final String DATABASE = "SpatialMetadata";
    public static final String JNDI = "jdbc/SpatialMetadata";
    public static final String EMBEDDED = "Embedded";
    private static Supplier<DataSource> supplier;
    private static DataSource source;
    private static boolean connected;

    protected Initializer() {
    }

    protected abstract void createSchema(Connection var1) throws SQLException;

    protected abstract void dataSourceChanged();

    public static synchronized boolean setDefault(Supplier<DataSource> supplier) {
        if (source == null) {
            Initializer.supplier = supplier;
            return true;
        }
        return false;
    }

    public static synchronized DataSource getDataSource() throws Exception {
        if (source == null) {
            LocalDataSource[] localDataSourceArray;
            Object object;
            if (Initializer.hasJNDI()) {
                try {
                    object = (Context)InitialContext.doLookup("java:comp/env");
                    if (object != null) {
                        source = (DataSource)object.lookup(JNDI);
                        if (object instanceof EventContext) {
                            Listener.register((EventContext)object);
                        }
                        return source;
                    }
                }
                catch (NameNotFoundException | NoInitialContextException namingException) {
                    localDataSourceArray = Messages.getResources(null).getLogRecord(Level.CONFIG, (short)24, JNDI);
                    localDataSourceArray.setLoggerName("org.apache.sis.sql");
                    Logging.log(null, null, (LogRecord)localDataSourceArray);
                }
            }
            if (supplier != null && (source = supplier.get()) != null) {
                supplier = null;
                return source;
            }
            object = null;
            localDataSourceArray = null;
            boolean bl = DataDirectory.isUndefined();
            if (bl) {
                object = Initializer.embedded();
            }
            if (object == null) {
                localDataSourceArray = LocalDataSource.create(DATABASE, Dialect.DERBY, Dialect.HSQL);
                if (!bl && (localDataSourceArray == null || localDataSourceArray[0].create)) {
                    object = Initializer.embedded();
                }
            }
            if (object != null) {
                source = LocalDataSource.wrap((DataSource)object);
            } else if (localDataSourceArray != null) {
                source = LocalDataSource.findDriver(localDataSourceArray);
            } else {
                return null;
            }
            supplier = null;
            if (source.isWrapperFor(LocalDataSource.class)) {
                Shutdown.register(() -> {
                    Initializer.shutdown();
                    return null;
                });
            }
            if (source instanceof LocalDataSource) {
                ((LocalDataSource)source).createDatabase();
            }
        }
        return source;
    }

    public static boolean hasJNDI() {
        return NamingManager.hasInitialContextFactoryBuilder() || AccessController.doPrivileged(Initializer::isContextDefined) != false;
    }

    private static Boolean isContextDefined() {
        return System.getProperty("java.naming.factory.initial") != null;
    }

    private static DataSource embedded() {
        for (InstallationResources installationResources : DefaultFactories.createServiceLoader(InstallationResources.class)) {
            if (!installationResources.getAuthorities().contains(EMBEDDED)) continue;
            try {
                String[] stringArray = installationResources.getResourceNames(EMBEDDED);
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    if (!DATABASE.equals(stringArray[i]) || !((object = installationResources.getResource(EMBEDDED, i)) instanceof DataSource)) continue;
                    return (DataSource)object;
                }
            }
            catch (IOException iOException) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.sql"), Initializer.class, "getDataSource", iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogRecord connected(DatabaseMetaData databaseMetaData) throws SQLException {
        Object object = Initializer.class;
        synchronized (Initializer.class) {
            Level level = connected ? Level.FINE : Level.CONFIG;
            connected = true;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            object = Messages.getResources(null).getLogRecord(level, (short)6, SQLUtilities.getSimplifiedURL(databaseMetaData));
            ((LogRecord)object).setLoggerName("org.apache.sis.system");
            return object;
        }
    }

    public static Object unspecified(Locale locale, boolean bl) {
        String string;
        short s;
        if (Initializer.hasJNDI()) {
            s = 24;
            string = JNDI;
        } else {
            s = 16;
            string = "SIS_DATA";
        }
        Messages messages = Messages.getResources(locale);
        return bl ? messages.getLogRecord(Level.WARNING, s, string) : messages.getString(s, string);
    }

    private static synchronized void shutdown() throws ReflectiveOperationException, SQLException {
        DataSource dataSource = source;
        source = null;
        connected = false;
        dataSource.unwrap(LocalDataSource.class).shutdown();
    }

    private static final class Listener
    implements ObjectChangeListener,
    Callable<Object> {
        private final EventContext context;

        private Listener(EventContext eventContext) {
            this.context = eventContext;
        }

        static void register(EventContext eventContext) throws NamingException {
            Listener listener = new Listener(eventContext);
            eventContext.addNamingListener(Initializer.JNDI, 0, (NamingListener)listener);
            Shutdown.register(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws NamingException {
            Class<Initializer> clazz = Initializer.class;
            synchronized (Initializer.class) {
                source = null;
                connected = false;
                this.context.removeNamingListener(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        @Override
        public void objectChanged(NamingEvent namingEvent) {
            Shutdown.unregister(this);
            try {
                this.call();
            }
            catch (NamingException namingException) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), Listener.class, "objectChanged", namingException);
            }
            for (Initializer initializer : DefaultFactories.createServiceLoader(Initializer.class)) {
                initializer.dataSourceChanged();
            }
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.system"), Listener.class, "namingExceptionThrown", namingExceptionEvent.getException());
            this.objectChanged(null);
        }
    }
}

